/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.connection;

import com.nvidia.common.toolkit.AbstractToolkit;
import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.OS;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;

public final class CudaToolkitWorkingCopy
extends AbstractToolkit
implements ICudaToolkit {
    private String binDirectory;
    private final String defaultName;
    private String id;
    private String[] paths = new String[0];
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport((Object)this);

    public CudaToolkitWorkingCopy(ICudaToolkit toolkit) {
        this(toolkit != null ? toolkit.getId() : null, toolkit != null ? toolkit.getName() : null);
        if (toolkit != null) {
            this.binDirectory = toolkit.getBinDirectory();
            this.paths = toolkit.getLibraryPath();
            ICudaToolkit.Tool[] toolArray = ICudaToolkit.Tool.values();
            int n = toolArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICudaToolkit.Tool tool = toolArray[n2];
                this.setToolPath(tool, toolkit.getToolPath(tool));
                ++n2;
            }
        }
    }

    public CudaToolkitWorkingCopy(String id, String name) {
        this.id = id;
        this.defaultName = name;
    }

    public void addLibraryPath(String path) {
        Object[] array = this.paths;
        int index = CoreUtil.indexOf((Object[])array, (Object)path);
        if (index < 0) {
            this.paths = (String[])Arrays.copyOf(array, array.length + 1);
            this.paths[array.length] = path;
            this.fireLibraryPropertyChange((String[])array);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CudaToolkitWorkingCopy other = (CudaToolkitWorkingCopy)((Object)obj);
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    private void fireLibraryPropertyChange(String[] oldValue) {
        this.propertyChangeSupport.firePropertyChange("libraryPath", oldValue, this.paths);
    }

    public String getBinDirectory() {
        return this.binDirectory;
    }

    public String getId() {
        return this.id;
    }

    public String[] getLibraryPath() {
        return this.paths;
    }

    public String getName() {
        String binDirectory = this.getBinDirectory();
        return CoreUtil.isNullOrEmpty((String)binDirectory) ? this.defaultName : binDirectory;
    }

    protected OS getToolkitOS() {
        return OS.Linux;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public void removeLibraryPath(String path) {
        Object[] array = this.paths;
        int index = CoreUtil.indexOf((Object[])array, (Object)path);
        if (index >= 0) {
            if (index == array.length - 1) {
                this.paths = (String[])Arrays.copyOf(array, array.length - 1);
            } else {
                this.paths = new String[array.length - 1];
                if (index > 0) {
                    System.arraycopy(array, 0, this.paths, 0, index);
                }
                System.arraycopy(array, index + 1, this.paths, index, this.paths.length - index);
            }
            this.fireLibraryPropertyChange((String[])array);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void replaceLibraryPath(String oldValue, String newValue) {
        int index = CoreUtil.indexOf((Object[])this.paths, (Object)oldValue);
        if (index >= 0) {
            String[] oldArray = this.paths;
            this.paths = Arrays.copyOf(this.paths, this.paths.length);
            this.paths[index] = newValue;
            this.fireLibraryPropertyChange(oldArray);
        }
    }

    public void replacePaths(String[] oldPaths, String[] newPaths) {
        Object[] oldValue = this.paths;
        if (CoreUtil.isNullOrEmpty((Object[])this.paths)) {
            this.paths = newPaths;
        } else {
            LinkedHashSet<String> set = new LinkedHashSet<String>(Arrays.asList(oldValue));
            if (oldPaths == null) {
                set.clear();
            } else if (!CoreUtil.isNullOrEmpty((Object[])oldPaths)) {
                set.removeAll(Arrays.asList(oldPaths));
            }
            if (!CoreUtil.isNullOrEmpty((Object[])newPaths)) {
                set.removeAll(Arrays.asList(newPaths));
            }
            this.paths = new String[newPaths.length + set.size()];
            int i = 0;
            while (i < newPaths.length) {
                this.paths[i] = newPaths[i];
                ++i;
            }
            for (String path : set) {
                this.paths[i++] = path;
            }
        }
        if (!CoreUtil.equalsIgnoringOrder((Object[])oldValue, (Object[])this.paths)) {
            this.fireLibraryPropertyChange((String[])oldValue);
        }
    }

    public void setBinDirectory(String binDirectory) {
        if (!CoreUtil.equals((Object)binDirectory, (Object)this.binDirectory)) {
            String old = this.binDirectory;
            this.binDirectory = binDirectory;
            this.propertyChangeSupport.firePropertyChange("binDirectory", old, binDirectory);
            this.propertyChangeSupport.firePropertyChange("name", old, this.getName());
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
    }

    public void setToolPath(ICudaToolkit.Tool tool, String path) {
        super.setToolPath(tool, path);
    }

    public Map<ICudaToolkit.Tool, String> getCustomizedToolPaths() {
        return super.getCustomizedToolPaths();
    }

    public void swapLibraryPaths(int index1, int index2) {
        String[] oldValue = this.paths;
        this.paths = Arrays.copyOf(this.paths, this.paths.length);
        String value = this.paths[index1];
        this.paths[index1] = this.paths[index2];
        this.paths[index2] = value;
        this.fireLibraryPropertyChange(oldValue);
    }
}

