/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.properties;

import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.parts.SessionEditPart;
import com.nvidia.viper.parts.TimelineEditPart;
import com.nvidia.viper.ui.PCIePropertyControl;
import com.nvidia.viper.ui.PCSamplingPeriodControl;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class PCIePropertySection
extends AbstractPropertySection {
    private PCIePropertyControl pciePropertyControl;
    private PCSamplingPeriodControl pcSamplingPeriodControl;

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Session session = null;
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof SessionEditPart) {
            session = ((SessionEditPart)input).getCastedModel();
        } else if (input instanceof TimelineEditPart) {
            session = ((TimelineEditPart)input).getCastedModel().getSession();
        }
        this.pciePropertyControl.setInput(session);
        this.pcSamplingPeriodControl.setInput(session);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage page) {
        super.createControls(parent, page);
        Composite top = this.getWidgetFactory().createFlatFormComposite(parent);
        this.pciePropertyControl = new PCIePropertyControl(top, 128);
        FormData dataPropertyControl = new FormData();
        dataPropertyControl.left = new FormAttachment(0, 0);
        dataPropertyControl.right = new FormAttachment(100, 0);
        dataPropertyControl.top = new FormAttachment(0, 4);
        this.pciePropertyControl.setLayoutData(dataPropertyControl);
        this.pciePropertyControl.setBackgroundMode(1);
        this.pciePropertyControl.setBackground(top.getBackground());
        this.pcSamplingPeriodControl = new PCSamplingPeriodControl(top, 1024);
        FormData dataSamplingControl = new FormData();
        dataSamplingControl.left = new FormAttachment(0, 0);
        dataSamplingControl.right = new FormAttachment(100, 0);
        dataSamplingControl.top = new FormAttachment((Control)this.pciePropertyControl, 50);
        this.pcSamplingPeriodControl.setLayoutData(dataSamplingControl);
        this.pcSamplingPeriodControl.setBackgroundMode(1);
        this.pcSamplingPeriodControl.setBackground(top.getBackground());
        ViperHelp.setContextHelp((Control)parent, ViperHelp.SETTINGS_VIEW_CONTEXT_ID);
    }

    public void refresh() {
        this.pciePropertyControl.refresh();
        this.pcSamplingPeriodControl.refresh();
    }
}

