/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.base.AbstractHelpScope;
import org.eclipse.help.internal.base.scope.ScopeUtils;
import org.eclipse.help.internal.base.util.CriteriaUtilities;
import org.eclipse.help.internal.criteria.CriterionResource;
import org.eclipse.help.internal.webapp.data.RequestData;
import org.eclipse.help.internal.webapp.data.RequestScope;
import org.eclipse.help.internal.webapp.data.ServletResources;
import org.eclipse.help.internal.webapp.servlet.WebappWorkingSetManager;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableToc;
import org.eclipse.help.internal.workingset.AdaptableTocsArray;
import org.eclipse.help.internal.workingset.AdaptableTopic;
import org.eclipse.help.internal.workingset.WorkingSet;

public class WorkingSetData
extends RequestData {
    public static final short STATE_UNCHECKED = 0;
    public static final short STATE_GRAYED = 1;
    public static final short STATE_CHECKED = 2;
    private WebappWorkingSetManager wsmgr;
    private AdaptableToc[] tocs;
    private boolean isEditMode;
    private AbstractHelpScope filter;
    static /* synthetic */ Class class$0;

    public WorkingSetData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
        this.wsmgr = new WebappWorkingSetManager(request, response, this.getLocale());
        AdaptableTocsArray adaptableTocs = this.wsmgr.getRoot();
        this.tocs = (AdaptableToc[])adaptableTocs.getChildren();
        this.isEditMode = "edit".equals(this.getOperation());
        this.filter = RequestScope.getScope(request, response, true);
    }

    public boolean isEditMode() {
        return this.isEditMode;
    }

    public String getWorkingSetName() {
        String name = this.request.getParameter("workingSet");
        if (name == null) {
            name = "";
        }
        return name;
    }

    public WorkingSet getWorkingSet() {
        String name = this.getWorkingSetName();
        if (name != null && name.length() > 0) {
            return this.wsmgr.getWorkingSet(name);
        }
        return null;
    }

    public short getTocState(int toc) {
        if (!this.isEditMode()) {
            return 0;
        }
        WorkingSet ws = this.getWorkingSet();
        if (ws == null) {
            return 0;
        }
        if (toc < 0 || toc >= this.tocs.length) {
            return 0;
        }
        AdaptableToc adaptableToc = this.tocs[toc];
        AdaptableHelpResource[] elements = ws.getElements();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] == adaptableToc) {
                return 2;
            }
            ++i;
        }
        int topics = adaptableToc.getChildren().length;
        boolean allTheSame = true;
        short baseValue = 0;
        if (topics > 0) {
            baseValue = this.getTopicState(toc, 0);
        }
        int i2 = 1;
        while (allTheSame && i2 < topics) {
            allTheSame = allTheSame && this.getTopicState(toc, i2) == baseValue;
            ++i2;
        }
        if (!allTheSame) {
            return 1;
        }
        return 0;
    }

    public boolean isTocEnabled(int tocIndex) {
        AdaptableToc adaptableToc = this.tocs[tocIndex];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.help.IToc");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IToc toc = (IToc)adaptableToc.getAdapter((Class)clazz);
        return ScopeUtils.showInTree((IToc)toc, (AbstractHelpScope)this.filter);
    }

    public boolean isTopicEnabled(int tocIndex, int topicIndex) {
        AdaptableToc adaptableToc = this.tocs[tocIndex];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.help.IToc");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IToc toc = (IToc)adaptableToc.getAdapter((Class)clazz);
        return ScopeUtils.showInTree((ITopic)toc.getTopics()[topicIndex], (AbstractHelpScope)this.filter);
    }

    public short getTopicState(int toc, int topic) {
        if (!this.isEditMode) {
            return 0;
        }
        WorkingSet ws = this.getWorkingSet();
        if (ws == null) {
            return 0;
        }
        if (toc < 0 || toc >= this.tocs.length) {
            return 0;
        }
        AdaptableToc parent = this.tocs[toc];
        AdaptableTopic[] topics = (AdaptableTopic[])parent.getChildren();
        if (topic < 0 || topic >= topics.length) {
            return 0;
        }
        AdaptableTopic adaptableTopic = topics[topic];
        AdaptableHelpResource[] elements = ws.getElements();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] == adaptableTopic) {
                return 2;
            }
            ++i;
        }
        return 0;
    }

    public String getOperation() {
        return this.request.getParameter("operation");
    }

    public int getTocCount() {
        return this.tocs.length;
    }

    public String getTocLabel(int i) {
        return this.tocs[i].getLabel();
    }

    public String getTocHref(int i) {
        return this.tocs[i].getHref();
    }

    public int getTopicCount(int toc) {
        return this.tocs[toc].getTopics().length;
    }

    public String getTopicLabel(int toc, int topic) {
        return this.tocs[toc].getTopics()[topic].getLabel();
    }

    public String getDefaultName() {
        int i = 1;
        while (i < 100) {
            String name = String.valueOf(ServletResources.getString("DefaultScopeName", this.request)) + i;
            if (this.wsmgr.getWorkingSet(name) == null) {
                return name;
            }
            ++i;
        }
        return "";
    }

    public boolean isCriteriaScopeEnabled() {
        return this.wsmgr.isCriteriaScopeEnabled();
    }

    public String[] getCriterionIds() {
        return this.wsmgr.getCriterionIds();
    }

    public String[] getCriterionValueIds(String criterionId) {
        return this.wsmgr.getCriterionValueIds(criterionId);
    }

    public String getCriterionDisplayName(String criterionId) {
        return this.wsmgr.getCriterionDisplayName(criterionId);
    }

    public String getCriterionValueDisplayName(String criterionId, String criterionValueId) {
        return this.wsmgr.getCriterionValueDisplayName(criterionId, criterionValueId);
    }

    public short getCriterionCategoryState(int index) {
        HashSet<String> criterionValuesSet;
        String[] categories = this.getCriterionIds();
        if (!this.isEditMode()) {
            return 0;
        }
        WorkingSet ws = this.getWorkingSet();
        if (ws == null) {
            return 0;
        }
        if (index < 0 || index >= categories.length) {
            return 0;
        }
        String category = categories[index];
        HashMap criteriaMap = new HashMap();
        CriterionResource[] criteria = ws.getCriteria();
        CriteriaUtilities.addCriteriaToMap(criteriaMap, (CriterionResource[])criteria);
        if (!criteriaMap.keySet().contains(category)) {
            return 0;
        }
        Set criterionValuesFromWS = (Set)criteriaMap.get(category);
        if (criterionValuesFromWS.containsAll(criterionValuesSet = new HashSet<String>(Arrays.asList(this.getCriterionValueIds(category))))) {
            return 2;
        }
        return 1;
    }

    public short getCriterionValueState(int categoryIndex, int valueIndex) {
        String[] categories = this.getCriterionIds();
        if (!this.isEditMode) {
            return 0;
        }
        WorkingSet ws = this.getWorkingSet();
        if (ws == null) {
            return 0;
        }
        if (categoryIndex < 0 || categoryIndex >= categories.length) {
            return 0;
        }
        String category = categories[categoryIndex];
        HashMap criteriaMap = new HashMap();
        CriterionResource[] criteria = ws.getCriteria();
        CriteriaUtilities.addCriteriaToMap(criteriaMap, (CriterionResource[])criteria);
        Set criterionValuesFromWS = (Set)criteriaMap.get(category);
        String[] crietriaValues = this.getCriterionValueIds(category);
        if (valueIndex < 0 || valueIndex >= crietriaValues.length) {
            return 0;
        }
        String relatedCriterionValue = crietriaValues[valueIndex];
        if (criterionValuesFromWS.contains(relatedCriterionValue)) {
            return 2;
        }
        return 0;
    }
}

