/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.remoting;

import flex.management.BaseControl;
import flex.management.runtime.messaging.services.remoting.RemotingDestinationControl;
import flex.messaging.FactoryDestination;
import flex.messaging.MessageBroker;
import flex.messaging.MessageException;
import flex.messaging.services.RemotingService;
import flex.messaging.services.Service;
import flex.messaging.util.MethodMatcher;

public class RemotingDestination
extends FactoryDestination {
    static final long serialVersionUID = -8454338922948146048L;
    public static final String LOG_CATEGORY = "Service.Remoting";
    private static final String REMOTING_SERVICE_CLASS = "flex.messaging.services.RemotingService";
    public static final int NO_MESSAGE_BROKER = 10163;
    private static final int NO_REMOTING_SERVICE = 10657;
    private MethodMatcher methodMatcher;
    private RemotingDestinationControl controller;

    public RemotingDestination() {
        this(false);
    }

    public RemotingDestination(boolean enableManagement) {
        super(enableManagement);
    }

    public static RemotingDestination getRemotingDestination(String serverId, String destinationName) {
        MessageBroker broker = MessageBroker.getMessageBroker((String)serverId);
        if (broker == null) {
            MessageException me = new MessageException();
            me.setMessage(10163, new Object[]{serverId});
            throw me;
        }
        RemotingService rs = (RemotingService)broker.getServiceByType(REMOTING_SERVICE_CLASS);
        if (rs == null) {
            MessageException me = new MessageException();
            me.setMessage(10657, new Object[]{serverId});
            throw me;
        }
        return (RemotingDestination)rs.getDestination(destinationName);
    }

    public String getLogCategory() {
        return LOG_CATEGORY;
    }

    public void setService(Service service) {
        RemotingService remotingService = (RemotingService)service;
        super.setService((Service)remotingService);
        this.setMethodMatcher(remotingService.getMethodMatcher());
    }

    public MethodMatcher getMethodMatcher() {
        return this.methodMatcher;
    }

    public void setMethodMatcher(MethodMatcher matcher) {
        this.methodMatcher = matcher;
    }

    protected void setupDestinationControl(Service service) {
        this.controller = new RemotingDestinationControl(this, service.getControl());
        this.controller.register();
        this.setControl((BaseControl)this.controller);
    }
}

