/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureWrapping.xpath.weakness;

import java.util.ArrayList;
import java.util.List;
import wsattacker.library.schemaanalyzer.SchemaAnalyzer;
import wsattacker.library.signatureWrapping.option.PayloadElement;
import wsattacker.library.signatureWrapping.option.SignedElement;
import wsattacker.library.signatureWrapping.util.exception.InvalidWeaknessException;
import wsattacker.library.signatureWrapping.util.signature.ReferenceElement;
import wsattacker.library.signatureWrapping.util.signature.XPathElement;
import wsattacker.library.signatureWrapping.xpath.interfaces.XPathWeaknessFactoryInterface;
import wsattacker.library.signatureWrapping.xpath.interfaces.XPathWeaknessInterface;
import wsattacker.library.signatureWrapping.xpath.parts.AbsoluteLocationPath;
import wsattacker.library.signatureWrapping.xpath.parts.Step;
import wsattacker.library.signatureWrapping.xpath.weakness.EnvelopedTransformationWeakness;
import wsattacker.library.signatureWrapping.xpath.weakness.XPathAttributeWeakness;
import wsattacker.library.signatureWrapping.xpath.weakness.XPathDescendantWeakness;
import wsattacker.library.signatureWrapping.xpath.weakness.XPathNamespaceInjectionWeakness;

public class XPathWeaknessFactory
implements XPathWeaknessFactoryInterface {
    @Override
    public List<XPathWeaknessInterface> generate(AbsoluteLocationPath xpath, SignedElement signedElement, PayloadElement payloadElement, SchemaAnalyzer schemaAnalyser) {
        int i;
        ArrayList<XPathWeaknessInterface> weaknessList = new ArrayList<XPathWeaknessInterface>();
        List<Step> steps = xpath.getRelativeLocationPaths();
        if (xpath.getReferringElement() instanceof ReferenceElement && xpath.getReferringElement().getXPath().equals(((ReferenceElement)xpath.getReferringElement()).transformIDtoXPath())) {
            try {
                XPathDescendantWeakness weakness = new XPathDescendantWeakness(steps.get(0), signedElement, payloadElement, schemaAnalyser);
                try {
                    EnvelopedTransformationWeakness evelopedTransformation = new EnvelopedTransformationWeakness(weakness, signedElement);
                    weaknessList.add(evelopedTransformation);
                }
                catch (InvalidWeaknessException e) {
                    weaknessList.add(weakness);
                }
            }
            catch (InvalidWeaknessException e) {
                // empty catch block
            }
            return weaknessList;
        }
        for (i = 0; i < steps.size(); ++i) {
            Step cur = steps.get(i);
            try {
                weaknessList.add(new XPathDescendantWeakness(cur, signedElement, payloadElement, schemaAnalyser));
            }
            catch (InvalidWeaknessException e) {
                // empty catch block
            }
            try {
                weaknessList.add(new XPathAttributeWeakness(cur, signedElement, payloadElement));
            }
            catch (InvalidWeaknessException e) {
                // empty catch block
            }
            try {
                weaknessList.add(new XPathNamespaceInjectionWeakness((XPathElement)xpath.getReferringElement(), cur, signedElement, payloadElement));
                continue;
            }
            catch (InvalidWeaknessException e) {
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (i = 0; i < weaknessList.size(); ++i) {
            XPathWeaknessInterface weakness = (XPathWeaknessInterface)weaknessList.get(i);
            try {
                EnvelopedTransformationWeakness evelopedTransformation = new EnvelopedTransformationWeakness(weakness, signedElement);
                weaknessList.add(i, evelopedTransformation);
                weaknessList.remove(i + 1);
                continue;
            }
            catch (InvalidWeaknessException e) {
                // empty catch block
            }
        }
        return weaknessList;
    }
}

