/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureWrapping.xpath.parts.predicate.factory;

import wsattacker.library.signatureWrapping.util.exception.InvalidTypeException;
import wsattacker.library.signatureWrapping.xpath.parts.predicate.AndExpression;
import wsattacker.library.signatureWrapping.xpath.parts.util.XPathInspectorTools;

public abstract class AbstractFunctionAndExpression
extends AndExpression {
    protected String functionName;
    protected String value;

    public AbstractFunctionAndExpression(String expression, String functionName) throws InvalidTypeException {
        super(expression);
        int end;
        int start;
        this.functionName = functionName;
        String functionNameEq = functionName + "=";
        if (expression.startsWith(functionNameEq)) {
            start = functionNameEq.length();
            char quote = expression.charAt(start);
            if (quote != '\"' && quote != '\'') {
                throw new InvalidTypeException();
            }
            end = XPathInspectorTools.nextChar(expression, quote, start + 1);
            if (end < 0) {
                throw new InvalidTypeException();
            }
        } else {
            throw new InvalidTypeException();
        }
        this.value = expression.substring(start + 1, end);
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getValue() {
        return this.value;
    }
}

