/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureWrapping.xpath.parts;

import java.util.ArrayList;
import java.util.List;
import wsattacker.library.signatureWrapping.xpath.interfaces.XPathPartInterface;
import wsattacker.library.signatureWrapping.xpath.parts.axis.AxisSpecifier;
import wsattacker.library.signatureWrapping.xpath.parts.predicate.Predicate;
import wsattacker.library.signatureWrapping.xpath.parts.util.XPathInspectorTools;

public class Step
implements XPathPartInterface {
    private final String step;
    private Step nextStep;
    private Step previousStep;
    private AxisSpecifier axisSpecifier;
    private List<Predicate> predicates;

    public Step(String relativeLocationPath) {
        this.step = relativeLocationPath;
        this.predicates = new ArrayList<Predicate>();
        this.nextStep = null;
        this.previousStep = null;
        this.eval();
    }

    public String getStep() {
        return this.step;
    }

    public Step getPreviousStep() {
        return this.previousStep;
    }

    protected void setPreviousStep(Step previousStep) {
        this.previousStep = previousStep;
    }

    public Step getNextStep() {
        return this.nextStep;
    }

    protected void setNextStep(Step nextStep) {
        this.nextStep = nextStep;
    }

    public void setPredicates(List<Predicate> predicates) {
        this.predicates = predicates;
    }

    public AxisSpecifier getAxisSpecifier() {
        return this.axisSpecifier;
    }

    public List<Predicate> getPredicates() {
        return this.predicates;
    }

    public String toString() {
        return this.step;
    }

    @Override
    public String toFullString() {
        return this.axisSpecifier.toFullString() + XPathInspectorTools.implodeList(this.predicates, "", "[", "]");
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof String) {
            result = this.equals(new Step((String)o));
        }
        if (o instanceof Step) {
            Step rel = (Step)o;
            result = rel.getAxisSpecifier().equals(this.getAxisSpecifier()) && rel.getPredicates().equals(this.getPredicates());
        }
        return result;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.step != null ? this.step.hashCode() : 0);
        return hash;
    }

    private void eval() {
        int open = this.nextOpeningBrace(0);
        if (open < 0) {
            this.axisSpecifier = new AxisSpecifier(this.step);
            return;
        }
        this.axisSpecifier = new AxisSpecifier(this.step.substring(0, open));
        while (open > 0) {
            int close = this.nextClosingBrace(open + 1);
            String pred = this.step.substring(open + 1, close);
            this.predicates.add(new Predicate(pred));
            open = this.nextOpeningBrace(close + 1);
        }
    }

    private int nextOpeningBrace(int startIndex) {
        return XPathInspectorTools.nextChar(this.step, '[', startIndex);
    }

    private int nextClosingBrace(int startIndex) {
        return XPathInspectorTools.nextChar(this.step, ']', startIndex);
    }

    public String getPreXPath() {
        StringBuffer buf = new StringBuffer();
        for (Step it = this.getPreviousStep(); it != null; it = it.getPreviousStep()) {
            buf.insert(0, it.getStep()).insert(0, '/');
        }
        return buf.toString();
    }

    public String getPostXPath() {
        StringBuffer buf = new StringBuffer();
        for (Step it = this.getNextStep(); it != null; it = it.getNextStep()) {
            buf.append('/').append(it.getStep());
        }
        if (buf.length() > 0) {
            buf.deleteCharAt(0);
        }
        return buf.toString();
    }
}

