/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureWrapping.xpath.parts;

import java.util.ArrayList;
import java.util.List;
import wsattacker.library.signatureWrapping.util.signature.ReferringElementInterface;
import wsattacker.library.signatureWrapping.xpath.interfaces.XPathPartInterface;
import wsattacker.library.signatureWrapping.xpath.parts.Step;
import wsattacker.library.signatureWrapping.xpath.parts.util.XPathInspectorTools;

public class AbsoluteLocationPath
implements XPathPartInterface {
    private String absoluteLocationPath;
    private List<Step> relativeLocationPaths;
    private ReferringElementInterface referringElement = null;

    public AbsoluteLocationPath(ReferringElementInterface ref) {
        this(ref.getXPath());
        this.referringElement = ref;
    }

    public AbsoluteLocationPath(String absoluteLocationPath) {
        this.absoluteLocationPath = absoluteLocationPath;
        this.relativeLocationPaths = new ArrayList<Step>();
        this.eval();
    }

    public String getAbsoluteLocationPath() {
        return this.absoluteLocationPath;
    }

    public List<Step> getRelativeLocationPaths() {
        return this.relativeLocationPaths;
    }

    public ReferringElementInterface getReferringElement() {
        return this.referringElement;
    }

    public String toString() {
        return this.absoluteLocationPath;
    }

    @Override
    public String toFullString() {
        return "/" + XPathInspectorTools.implodeList(this.relativeLocationPaths, "/");
    }

    public boolean equals(Object o) {
        if (o instanceof String) {
            return this.equals(new AbsoluteLocationPath((String)o));
        }
        if (o instanceof AbsoluteLocationPath) {
            AbsoluteLocationPath abs = (AbsoluteLocationPath)o;
            return abs.getAbsoluteLocationPath().equals(this.getAbsoluteLocationPath());
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.absoluteLocationPath != null ? this.absoluteLocationPath.hashCode() : 0);
        return hash;
    }

    private void eval() {
        Step currentStep;
        String relString;
        int prev = 0;
        if (this.absoluteLocationPath.charAt(0) != '/') {
            return;
        }
        int next = this.nextSlash(prev + 1);
        Step previousStep = null;
        while (next > 0) {
            relString = this.absoluteLocationPath.substring(prev + 1, next);
            currentStep = new Step(relString);
            if (previousStep != null) {
                currentStep.setPreviousStep(previousStep);
                previousStep.setNextStep(currentStep);
            }
            this.relativeLocationPaths.add(currentStep);
            previousStep = currentStep;
            prev = next;
            next = this.nextSlash(prev + 1);
        }
        relString = this.absoluteLocationPath.substring(prev + 1, this.absoluteLocationPath.length());
        currentStep = new Step(relString);
        if (previousStep != null) {
            currentStep.setPreviousStep(previousStep);
            previousStep.setNextStep(currentStep);
        }
        this.relativeLocationPaths.add(currentStep);
    }

    private int nextSlash(int startIndex) {
        return XPathInspectorTools.nextChar(this.absoluteLocationPath, '/', startIndex);
    }
}

