/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.signatureWrapping.util.signature;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wsattacker.library.signatureWrapping.option.Payload;
import wsattacker.library.signatureWrapping.util.signature.ReferringElementInterface;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class XPathElement
implements ReferringElementInterface {
    private static final String FILTER = "Filter";
    private final Element xpathElement;
    private final List<Payload> payloads;
    private final List<Element> matchedElements;
    private String workingXPath;

    public XPathElement(Element xpath) {
        this.xpathElement = xpath;
        this.workingXPath = "";
        this.payloads = new ArrayList<Payload>();
        this.log().trace((Object)String.format("Searching matched Elements for %s", DomUtilities.getFastXPath((Node)xpath)));
        this.matchedElements = new ArrayList<Element>();
        try {
            this.matchedElements.addAll(DomUtilities.evaluateXPath((Document)xpath.getOwnerDocument(), (String)this.getExpression()));
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(String.format("Could not evaluate XPath >> %s <<", this.getExpression()), e);
        }
        this.log().trace((Object)String.format("Found: %s", this.matchedElements));
        int anz = this.matchedElements.size();
        for (int i = 0; i < anz; ++i) {
            Element signedElement = this.matchedElements.get(i);
            Payload o = new Payload(this, signedElement);
            this.payloads.add(o);
        }
    }

    @Override
    public String getXPath() {
        if (this.workingXPath.isEmpty()) {
            this.workingXPath = this.xpathElement.getTextContent();
        }
        return this.workingXPath;
    }

    @Override
    public void setXPath(String workingXPath) {
        this.workingXPath = workingXPath;
    }

    public Element getXPathElement() {
        return this.xpathElement;
    }

    @Override
    public Element getElementNode() {
        return this.xpathElement;
    }

    public List<Payload> getPayloads() {
        return this.payloads;
    }

    public String getExpression() {
        return this.xpathElement.getTextContent();
    }

    public String getFilter() {
        return this.xpathElement.getAttribute(FILTER);
    }

    public List<Element> getReferencedElements() {
        return this.matchedElements;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof XPathElement) {
            XPathElement xpe = (XPathElement)o;
            result = xpe.getFilter().equals(this.getFilter()) && xpe.getExpression().equals(this.getExpression());
        }
        return result;
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + (this.getFilter() != null ? this.getFilter().hashCode() : 0);
        hash = 53 * hash + (this.getExpression() != null ? this.getExpression().hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XPathElement{xpathElement=").append(DomUtilities.getFastXPath((Node)this.xpathElement));
        sb.append(", matchedElements=").append(this.matchedElements);
        sb.append(", workingXPath=").append(this.workingXPath);
        sb.append('}').toString();
        return sb.toString();
    }

    private Logger log() {
        return Logger.getLogger(this.getClass());
    }
}

