/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services;

import flex.management.ManageableComponent;
import flex.management.runtime.messaging.MessageBrokerControl;
import flex.messaging.Destination;
import flex.messaging.MessageBroker;
import flex.messaging.MessageException;
import flex.messaging.cluster.ClusterManager;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationException;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.log.Log;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import flex.messaging.services.Service;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractService
extends ManageableComponent
implements Service {
    public static final String LOG_CATEGORY = "Service.General";
    public static final String LOG_CATEGORY_STARTUP_DESTINATION = "Startup.Destination";
    protected static final int UNKNOWN_MESSAGE_TYPE = 10454;
    protected Map adapterClasses = new HashMap();
    protected String defaultAdapterId;
    protected List defaultChannels;
    protected Map destinations = new ConcurrentHashMap();

    public AbstractService() {
        this(false);
    }

    public AbstractService(boolean enableManagement) {
        super(enableManagement);
    }

    protected void validate() {
        if (this.isValid()) {
            return;
        }
        super.validate();
        if (this.defaultChannels != null) {
            Iterator iter = this.defaultChannels.iterator();
            while (iter.hasNext()) {
                String id = (String)iter.next();
                if (this.getMessageBroker().getChannelIds().contains(id)) continue;
                iter.remove();
                if (!Log.isWarn()) continue;
                Log.getLogger((String)this.getLogCategory()).warn("Removing the Channel " + id + " from Destination " + this.getId() + "as MessageBroker does not know the channel");
            }
        } else {
            this.defaultChannels = this.getMessageBroker().getDefaultChannels();
        }
    }

    public void start() {
        if (this.isStarted()) {
            this.startDestinations();
            return;
        }
        MessageBroker broker = this.getMessageBroker();
        if (!broker.isStarted()) {
            if (Log.isWarn()) {
                Log.getLogger((String)this.getLogCategory()).warn("Service with id '{0}' cannot be started when the MessageBroker is not started.", new Object[]{this.getId()});
            }
            return;
        }
        if (this.isManaged() && broker.isManaged()) {
            this.setupServiceControl(broker);
            MessageBrokerControl controller = (MessageBrokerControl)broker.getControl();
            if (this.getControl() != null) {
                controller.addService(this.getControl().getObjectName());
            }
        }
        super.start();
        this.startDestinations();
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        this.stopDestinations();
        super.stop();
        if (this.isManaged() && this.getMessageBroker().isManaged()) {
            if (this.getControl() != null) {
                this.getControl().unregister();
                this.setControl(null);
            }
            this.setManaged(false);
        }
    }

    public Map getRegisteredAdapters() {
        return this.adapterClasses;
    }

    public String registerAdapter(String id, String adapterClass) {
        return this.adapterClasses.put(id, adapterClass);
    }

    public String unregisterAdapter(String id) {
        if (id != null && id.equals(this.defaultAdapterId)) {
            this.defaultAdapterId = null;
        }
        return (String)this.adapterClasses.remove(id);
    }

    public String getDefaultAdapter() {
        return this.defaultAdapterId;
    }

    public void setDefaultAdapter(String id) {
        if (this.adapterClasses.get(id) == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11114, new Object[]{id, this.getId()});
            throw ex;
        }
        this.defaultAdapterId = id;
    }

    public List getDefaultChannels() {
        return this.defaultChannels;
    }

    public void addDefaultChannel(String id) {
        List channelIds;
        if (this.defaultChannels == null) {
            this.defaultChannels = new ArrayList();
        } else if (this.defaultChannels.contains(id)) {
            return;
        }
        if (this.isStarted() && ((channelIds = this.getMessageBroker().getChannelIds()) == null || !channelIds.contains(id))) {
            if (Log.isWarn()) {
                Log.getLogger((String)this.getLogCategory()).warn("No channel with id '{0}' is known by the MessageBroker. Not adding the channel.", new Object[]{id});
            }
            return;
        }
        this.defaultChannels.add(id);
    }

    public void setDefaultChannels(List ids) {
        if (ids != null && this.isStarted()) {
            List channelIds = this.getMessageBroker().getChannelIds();
            Iterator iter = ids.iterator();
            while (iter.hasNext()) {
                String id = (String)iter.next();
                if (channelIds != null && channelIds.contains(id)) continue;
                iter.remove();
                if (!Log.isWarn()) continue;
                Log.getLogger((String)this.getLogCategory()).warn("No channel with id '{0}' is known by the MessageBroker. Not adding the channel.", new Object[]{id});
            }
        }
        this.defaultChannels = ids;
    }

    public boolean removeDefaultChannel(String id) {
        if (this.defaultChannels == null) {
            return false;
        }
        return this.defaultChannels.remove(id);
    }

    public Destination getDestination(Message message) {
        String id = message.getDestination();
        Destination result = this.getDestination(id);
        if (result == null) {
            throw new MessageException("No destination '" + id + "' exists in service " + this.getClass().getName());
        }
        return result;
    }

    public Destination getDestination(String id) {
        Destination result = (Destination)this.destinations.get(id);
        return result;
    }

    public Map getDestinations() {
        return this.destinations;
    }

    public Destination createDestination(String id) {
        Destination destination = new Destination();
        destination.setId(id);
        destination.setManaged(this.isManaged());
        destination.setService(this);
        return destination;
    }

    public void addDestination(Destination destination) {
        if (destination == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11110, new Object[]{"Destination", "Service"});
            throw ex;
        }
        String id = destination.getId();
        if (id == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11111, new Object[]{"Destination", "Service"});
            throw ex;
        }
        if (this.getDestination(id) == destination) {
            return;
        }
        this.getMessageBroker().registerDestination(id, this.getId());
        this.destinations.put(id, destination);
        if (destination.getService() == null || destination.getService() != this) {
            destination.setService(this);
        }
    }

    public Destination removeDestination(String id) {
        Destination destination = (Destination)this.destinations.get(id);
        if (destination != null) {
            destination.stop();
            this.destinations.remove(id);
            this.getMessageBroker().unregisterDestination(id);
        }
        return destination;
    }

    public void setId(String id) {
        String oldId = this.getId();
        super.setId(id);
        MessageBroker broker = this.getMessageBroker();
        if (broker != null) {
            broker.removeService(oldId);
            broker.addService(this);
        }
    }

    public MessageBroker getMessageBroker() {
        return (MessageBroker)this.getParent();
    }

    public void setMessageBroker(MessageBroker broker) {
        MessageBroker oldBroker = this.getMessageBroker();
        this.setParent(broker);
        if (oldBroker != null) {
            oldBroker.removeService(this.getId());
        }
        if (broker.getService(this.getId()) != this) {
            broker.addService(this);
        }
    }

    public ConfigMap describeService(Endpoint endpoint) {
        return null;
    }

    public abstract Object serviceMessage(Message var1);

    public Object serviceCommand(CommandMessage message) {
        Object result = this.serviceCommonCommands(message);
        if (result != null) {
            return result;
        }
        throw new MessageException("Service Does Not Support Command Type " + message.getOperation());
    }

    protected Object serviceCommonCommands(CommandMessage message) {
        Object commandResult = null;
        if (message.getOperation() == 5) {
            commandResult = Boolean.TRUE;
        } else if (message.getOperation() == 7) {
            String destinationName;
            String serviceType;
            ClusterManager clusterManager = this.getMessageBroker().getClusterManager();
            commandResult = clusterManager.isDestinationClustered(serviceType = this.getClass().getName(), destinationName = message.getDestination()) ? clusterManager.getEndpointsForDestination(serviceType, destinationName) : Boolean.FALSE;
        }
        return commandResult;
    }

    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    protected abstract void setupServiceControl(MessageBroker var1);

    private void startDestinations() {
        for (Destination destination : this.destinations.values()) {
            long timeBeforeStartup = 0L;
            if (Log.isDebug()) {
                timeBeforeStartup = System.currentTimeMillis();
            }
            destination.start();
            if (!Log.isDebug()) continue;
            long timeAfterStartup = System.currentTimeMillis();
            Long diffMillis = new Long(timeAfterStartup - timeBeforeStartup);
            Log.getLogger((String)LOG_CATEGORY_STARTUP_DESTINATION).debug("Destination with id '{0}' is ready (startup time: '{1}' ms)", new Object[]{destination.getId(), diffMillis});
        }
    }

    private void stopDestinations() {
        for (Destination destination : this.destinations.values()) {
            destination.stop();
        }
    }
}

