/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.intelligentdos.success;

import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.stat.inference.TestUtils;
import wsattacker.library.intelligentdos.success.AbstractSuccessDecider;
import wsattacker.library.intelligentdos.success.Efficiency;

public class TTestSuccessDecider
extends AbstractSuccessDecider {
    private static final double propability = 0.95;

    @Override
    public boolean wasSuccessful(Long[] run1, Long[] run2) {
        double pValue = this.calculateProbability(run1, run2);
        return pValue > 0.95;
    }

    @Override
    public Efficiency getEfficency(Long[] run1, Long[] run2) {
        double pValue = this.calculateProbability(run1, run2);
        if (pValue > 0.95) {
            return Efficiency.efficient;
        }
        return Efficiency.inefficient;
    }

    private double calculateProbability(Long[] run1, Long[] run2) {
        SummaryStatistics statisticsX = new SummaryStatistics();
        Long[] arr$ = run1;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double value = arr$[i$].longValue();
            statisticsX.addValue(value);
        }
        SummaryStatistics statisticsY = new SummaryStatistics();
        Long[] arr$2 = run2;
        int len$2 = arr$2.length;
        for (int i$ = 0; i$ < len$2; ++i$) {
            double value = arr$2[i$].longValue();
            statisticsY.addValue(value);
        }
        double t = TestUtils.t((StatisticalSummary)statisticsX, (StatisticalSummary)statisticsY);
        long degreesOfFreedom = statisticsX.getN() + statisticsY.getN() - 2L;
        TDistribution tDistribution = new TDistribution((double)degreesOfFreedom);
        double pValue = tDistribution.cumulativeProbability(t);
        return pValue;
    }
}

