/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.intelligentdos.position;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import wsattacker.library.intelligentdos.dos.DoSAttack;
import wsattacker.library.intelligentdos.position.AnyElementPosition;
import wsattacker.library.intelligentdos.position.Position;
import wsattacker.library.intelligentdos.position.PositionIterator;
import wsattacker.library.schemaanalyzer.AnyElementProperties;
import wsattacker.library.schemaanalyzer.SchemaAnalyzer;
import wsattacker.library.xmlutilities.dom.DomUtilities;

public class SchemaAnalyzerPositionIterator
implements PositionIterator {
    private static final Logger LOG = Logger.getLogger(SchemaAnalyzerPositionIterator.class);
    private final SchemaAnalyzer schemaAnalyzer;
    private Set<AnyElementProperties> expansionPoints;
    private final Map<DoSAttack.PayloadPosition, Iterator<AnyElementProperties>> anyElementIteratorMap = Maps.newHashMap();
    private final String xmlMessage;

    public SchemaAnalyzerPositionIterator(SchemaAnalyzer schemaAnalyzer, String xmlMessage) {
        if (schemaAnalyzer == null) {
            throw new IllegalArgumentException("schemaAnalyzer cannot be null!");
        }
        this.schemaAnalyzer = schemaAnalyzer;
        this.xmlMessage = xmlMessage;
        this.initialize();
    }

    private void initialize() {
        try {
            Document toAnalyze = DomUtilities.stringToDom((String)this.xmlMessage);
            this.expansionPoints = this.findExpansionPoints(toAnalyze);
            this.reset();
            LOG.info((Object)("Found " + this.expansionPoints.size() + " expansion points"));
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("xmlMessage cannot be parsed", e);
        }
    }

    private Set<AnyElementProperties> findExpansionPoints(Document toAnalyze) {
        Element documentElement = toAnalyze.getDocumentElement();
        return this.schemaAnalyzer.findExpansionPoint(documentElement);
    }

    @Override
    public void reset() {
        for (DoSAttack.PayloadPosition payloadPosition : new DoSAttack.PayloadPosition[]{DoSAttack.PayloadPosition.ELEMENT, DoSAttack.PayloadPosition.ATTRIBUTE}) {
            this.anyElementIteratorMap.put(payloadPosition, this.expansionPoints.iterator());
        }
    }

    @Override
    public boolean hasNext(DoSAttack.PayloadPosition payloadPosition) {
        Iterator<AnyElementProperties> iterator = this.anyElementIteratorMap.get((Object)payloadPosition);
        if (iterator != null) {
            return iterator.hasNext();
        }
        return false;
    }

    @Override
    public Position next(DoSAttack.PayloadPosition payloadPosition) {
        Iterator<AnyElementProperties> iterator = this.anyElementIteratorMap.get((Object)payloadPosition);
        if (iterator != null) {
            return new AnyElementPosition(this.xmlMessage, iterator.next());
        }
        throw new NoSuchElementException();
    }
}

