/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.intelligentdos.helper;

import java.io.Serializable;

public class CommonParamItem
implements Serializable,
Comparable<CommonParamItem> {
    private static final long serialVersionUID = 1L;
    private static final double SECOND_IN_MILLIES = 1000.0;
    private final int numberOfRequests;
    private final int numberOfThreads;
    private final int milliesBetweenRequests;

    public CommonParamItem(int numberOfRequests, int numberOfThreads, int milliesBetweenRequests) {
        this.numberOfRequests = numberOfRequests;
        this.numberOfThreads = numberOfThreads;
        this.milliesBetweenRequests = milliesBetweenRequests;
    }

    public CommonParamItem(int[] is) {
        if (is == null || is.length != 3) {
            throw new IllegalArgumentException("only a array with exactly three elements {requests, threads, millies} allowed");
        }
        this.numberOfRequests = is[0];
        this.numberOfThreads = is[1];
        this.milliesBetweenRequests = is[2];
    }

    public int getNumberOfRequests() {
        return this.numberOfRequests;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public int getMilliesBetweenRequests() {
        return this.milliesBetweenRequests;
    }

    public double getReuqestsPerSecond() {
        return 1000.0 / (double)this.milliesBetweenRequests * (double)this.numberOfThreads;
    }

    public String toString() {
        return String.format("CommonParams[requests=%d, threads=%d, millies=%d]", this.numberOfRequests, this.numberOfThreads, this.milliesBetweenRequests);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        CommonParamItem that = (CommonParamItem)obj;
        return this.numberOfRequests == that.numberOfRequests && this.numberOfThreads == that.numberOfThreads && this.milliesBetweenRequests == that.milliesBetweenRequests;
    }

    @Override
    public int compareTo(CommonParamItem o) {
        int BEFORE = -1;
        boolean EQUAL = false;
        boolean AFTER = true;
        if (this == o) {
            return 0;
        }
        if (this.numberOfRequests < o.numberOfRequests) {
            return -1;
        }
        if (this.numberOfRequests > o.numberOfRequests) {
            return 1;
        }
        if (this.numberOfThreads < o.numberOfThreads) {
            return -1;
        }
        if (this.numberOfThreads > o.numberOfThreads) {
            return 1;
        }
        if (this.milliesBetweenRequests < o.milliesBetweenRequests) {
            return -1;
        }
        if (this.milliesBetweenRequests > o.milliesBetweenRequests) {
            return 1;
        }
        return 0;
    }
}

