/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.intelligentdos.common;

import com.google.common.collect.ImmutableList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import wsattacker.library.intelligentdos.common.Metric;
import wsattacker.library.intelligentdos.common.RequestType;
import wsattacker.library.intelligentdos.dos.DoSAttack;
import wsattacker.library.intelligentdos.helper.CommonParamItem;
import wsattacker.library.intelligentdos.position.Position;

public class AttackModel {
    private static final double RATE_SUCCESSFUL_FAILED = 0.7;
    private int current;
    private CommonParamItem paramItem;
    private int serverRecoveryBeforeSend;
    private String requestContent;
    private Position position = null;
    private DoSAttack doSAttack = null;
    private DoSAttack.PayloadPosition payloadPosition;
    private RequestType requestType;
    private final List<Metric> list = new ArrayList<Metric>();
    private final List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();

    public String getRequestContent() {
        return this.requestContent;
    }

    public void setRequestContent(String requestContent) {
        this.requestContent = requestContent;
    }

    public CommonParamItem getParamItem() {
        return this.paramItem;
    }

    public void setParamItem(CommonParamItem paramItem) {
        this.paramItem = paramItem;
    }

    public int getNumberOfRequests() {
        return this.paramItem != null ? this.paramItem.getNumberOfRequests() : 0;
    }

    public int getNumberOfThreads() {
        return this.paramItem != null ? this.paramItem.getNumberOfThreads() : 0;
    }

    public int getMilliesBetweenRequests() {
        return this.paramItem != null ? this.paramItem.getMilliesBetweenRequests() : 0;
    }

    public int getServerRecoveryBeforeSend() {
        return this.serverRecoveryBeforeSend;
    }

    public void setServerRecoveryBeforeSend(int serverRecoveryBeforeSend) {
        this.serverRecoveryBeforeSend = serverRecoveryBeforeSend;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public void setRequestType(RequestType requestType) {
        this.requestType = requestType;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public DoSAttack.PayloadPosition getPayloadPosition() {
        return this.payloadPosition;
    }

    public void setPayloadPosition(DoSAttack.PayloadPosition payloadPosition) {
        this.payloadPosition = payloadPosition;
    }

    public DoSAttack getDoSAttack() {
        return this.doSAttack;
    }

    public void setDoSAttack(DoSAttack doSAttack) {
        this.doSAttack = doSAttack;
    }

    public int getErrorCount() {
        int count = 0;
        for (Metric metric : this.list) {
            if (!metric.isEmptyResponse() && !metric.isConnectionReset() && !metric.isReadTimedOut() && !metric.isSOAPFault()) continue;
            ++count;
        }
        return count;
    }

    public int getSOAPFaultCount() {
        int count = 0;
        for (Metric metric : this.list) {
            if (!metric.isSOAPFault()) continue;
            ++count;
        }
        return count;
    }

    public boolean wasAttackExecutionSuccessful() {
        if (this.list.size() > 0) {
            float rate = (float)(this.list.size() - this.getErrorCount()) / ((float)this.list.size() * 1.0f);
            return (double)rate > 0.7;
        }
        return true;
    }

    public boolean isAllFail() {
        float e = (float)this.getErrorCount() / ((float)this.list.size() * 1.0f);
        return (double)e > 0.95;
    }

    public boolean isAllSOAPFault() {
        return this.getSOAPFaultCount() == this.list.size();
    }

    public List<Metric> getMetrics() {
        return ImmutableList.copyOf(this.list);
    }

    public Long[] getDurationArray() {
        Long[] array = new Long[this.list.size()];
        int i = 0;
        for (Metric metric : this.list) {
            array[i++] = metric.getDuration();
        }
        return array;
    }

    public synchronized void addMetric(Metric metric) {
        this.list.add(metric);
    }

    public void increase() {
        int oldCurrent = this.current++;
        this.firePropertyChange(new PropertyChangeEvent(this, "current", oldCurrent, this.current));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(propertyChangeEvent);
        }
    }

    public int getProgress() {
        float total = (float)(this.getNumberOfRequests() * this.getNumberOfThreads()) * 1.0f;
        float result = (float)this.current * 1.0f / total * 100.0f;
        return (int)result;
    }

    public static AttackModelBuilder custom() {
        return new AttackModelBuilder();
    }

    public String toString() {
        return String.format("AttackModel[a=%s, e=%s, p=%s]", new Object[]{this.doSAttack.getName(), this.position, this.payloadPosition});
    }

    public static class AttackModelBuilder {
        private DoSAttack doSAttack = null;
        private RequestType requestType;
        private DoSAttack.PayloadPosition payloadPosition;
        private Position position = null;
        private CommonParamItem paramItem;
        private int recovery;

        public AttackModelBuilder withDoSAttack(DoSAttack doSAttack) {
            this.doSAttack = doSAttack;
            return this;
        }

        public AttackModelBuilder withRequestType(RequestType requestType) {
            this.requestType = requestType;
            return this;
        }

        public AttackModelBuilder withPayloadPosition(DoSAttack.PayloadPosition payloadPosition) {
            this.payloadPosition = payloadPosition;
            return this;
        }

        public AttackModelBuilder withPosition(Position position) {
            this.position = position;
            return this;
        }

        public AttackModelBuilder withParamItem(CommonParamItem paramItem) {
            this.paramItem = paramItem;
            return this;
        }

        public AttackModelBuilder withRecovery(int recovery) {
            this.recovery = recovery;
            return this;
        }

        public AttackModel build() {
            AttackModel attackModel = new AttackModel();
            attackModel.setRequestType(this.requestType);
            try {
                attackModel.setDoSAttack(this.doSAttack.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            attackModel.setPayloadPosition(this.payloadPosition);
            attackModel.setPosition(this.position);
            attackModel.setParamItem(this.paramItem);
            String xmlWithPlaceholder = this.position.createPlaceholder(this.payloadPosition);
            String content = "";
            if (this.requestType == RequestType.TAMPERED) {
                content = this.doSAttack.getTamperedRequest(xmlWithPlaceholder, this.payloadPosition);
            } else if (this.requestType == RequestType.UNTAMPERED) {
                content = this.doSAttack.getUntamperedRequest(xmlWithPlaceholder, this.payloadPosition);
            }
            attackModel.setRequestContent(content);
            attackModel.setServerRecoveryBeforeSend(this.recovery);
            return attackModel;
        }
    }
}

