/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.library.intelligentdos;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.stat.descriptive.SynchronizedDescriptiveStatistics;
import org.apache.log4j.Logger;
import wsattacker.library.intelligentdos.DoSState;
import wsattacker.library.intelligentdos.InitialState;
import wsattacker.library.intelligentdos.IntelligentDoSLibrary;
import wsattacker.library.intelligentdos.UntamperedState;
import wsattacker.library.intelligentdos.common.AttackModel;
import wsattacker.library.intelligentdos.common.DoSParam;
import wsattacker.library.intelligentdos.common.Metric;
import wsattacker.library.intelligentdos.common.RequestType;
import wsattacker.library.intelligentdos.common.SuccessfulAttack;
import wsattacker.library.intelligentdos.common.Threshold;
import wsattacker.library.intelligentdos.dos.CoerciveParsing;
import wsattacker.library.intelligentdos.dos.DoSAttack;
import wsattacker.library.intelligentdos.dos.HashCollision;
import wsattacker.library.intelligentdos.dos.XmlAttributeCount;
import wsattacker.library.intelligentdos.dos.XmlElementCount;
import wsattacker.library.intelligentdos.dos.XmlEntityExpansion;
import wsattacker.library.intelligentdos.dos.XmlExternalEntity;
import wsattacker.library.intelligentdos.dos.XmlOverlongNames;
import wsattacker.library.intelligentdos.helper.CommonParamItem;
import wsattacker.library.intelligentdos.position.Position;
import wsattacker.library.intelligentdos.position.PositionIterator;
import wsattacker.library.intelligentdos.success.SuccessDecider;

public class IntelligentDoSLibraryImpl
implements IntelligentDoSLibrary {
    private static final int UTR_THREADS = 4;
    private static final int UTR_REQUESTS = 8;
    public static final int DEFAULT_SERVER_RECOVERY = 20000;
    public static final List<CommonParamItem> COMMONPARAMS = new ArrayList<CommonParamItem>();
    private static final int[][] DEFAULTCOMMONPARAMS;
    private static final Logger LOG;
    private final String xmlMessage;
    private final PositionIterator positionIterator;
    private boolean hasFurtherAttack;
    boolean noFurtherIterations = false;
    private int serverRecovery = 0;
    private List<CommonParamItem> commonParamList;
    private DoSAttack[] attacks = IntelligentDoSLibraryImpl.getAllAttacks();
    private Iterator<DoSAttack> attackIterator;
    private Iterator<DoSAttack.PayloadPosition> payloadPositionIterator;
    private Iterator<CommonParamItem> commonParamsIterator;
    private AttackModel currentAttack;
    private DoSAttack currentDoSAttack;
    private DoSAttack.PayloadPosition currentPayloadPosition;
    private Position currentPosition;
    private CommonParamItem currentCommonParams;
    private SuccessDecider successDecider;
    private Long[] currentUntampered;
    private final List<SuccessfulAttack> successfulAttackList;
    private final List<DoSAttack> notPossibleList;
    private final List<Threshold> thresholdList;
    private double maximumRequestsPerSecond;
    private DoSState doSState = new InitialState();
    private boolean m_needRecovery;
    private final DescriptiveStatistics testProbeStatisticsShort = new SynchronizedDescriptiveStatistics(10);
    private final DescriptiveStatistics testProbeStatisticsLong = new SynchronizedDescriptiveStatistics(100);
    private final SummaryStatistics untamperedStatistics = new SummaryStatistics();

    public IntelligentDoSLibraryImpl(String xmlMessage, PositionIterator positionIterator) {
        if (xmlMessage == null) {
            throw new IllegalArgumentException("xmlMessage cannot be null!");
        }
        if (positionIterator == null) {
            throw new IllegalArgumentException("positionIterator cannot be null!");
        }
        this.positionIterator = positionIterator;
        this.xmlMessage = xmlMessage;
        this.successfulAttackList = new ArrayList<SuccessfulAttack>();
        this.notPossibleList = new ArrayList<DoSAttack>();
        this.thresholdList = new ArrayList<Threshold>();
        this.commonParamList = COMMONPARAMS;
    }

    @Override
    public void initialize() {
        this.attackIterator = Arrays.asList(this.attacks).iterator();
        for (DoSAttack doSAttack : this.attacks) {
            doSAttack.initialize();
        }
        this.currentDoSAttack = this.attackIterator.next();
        LOG.info((Object)("start with " + this.currentDoSAttack.getName()));
        this.payloadPositionIterator = Arrays.asList(this.currentDoSAttack.getPossiblePossitions()).iterator();
        while (this.payloadPositionIterator.hasNext() && !this.hasFurtherAttack) {
            this.currentPayloadPosition = this.payloadPositionIterator.next();
            if (!this.positionIterator.hasNext(this.currentPayloadPosition)) continue;
            this.hasFurtherAttack = true;
            this.currentPosition = this.positionIterator.next(this.currentPayloadPosition);
            this.currentAttack = this.createFirstAttack();
            this.doSState = new UntamperedState();
        }
    }

    public static DoSAttack[] getAllAttacks() {
        return new DoSAttack[]{new CoerciveParsing(), new XmlElementCount(), new XmlAttributeCount(), new XmlEntityExpansion(), new XmlExternalEntity(), new HashCollision(), new XmlOverlongNames()};
    }

    @Override
    public void setAttacks(DoSAttack[] attacks) {
        this.attacks = new DoSAttack[attacks.length];
        System.arraycopy(attacks, 0, this.attacks, 0, attacks.length);
    }

    public void setSuccessDecider(SuccessDecider successDecider) {
        this.successDecider = successDecider;
    }

    public void setCommonParams(List<CommonParamItem> commonParamList) {
        this.commonParamList = commonParamList;
    }

    public void setServerRecoveryTime(int timeInMillies) {
        this.serverRecovery = timeInMillies;
    }

    void setDoSState(DoSState doSState) {
        String format = String.format("switch state from %s to %s", this.doSState.getName(), doSState.getName());
        LOG.trace((Object)format);
        this.doSState = doSState;
    }

    AttackModel getCurrentAttack() {
        return this.currentAttack;
    }

    void setCurrentAttack(AttackModel currentAttack) {
        this.currentAttack = currentAttack;
    }

    void setHasFurtherAttack(boolean hasFurtherAttack) {
        this.hasFurtherAttack = hasFurtherAttack;
    }

    SuccessDecider getSuccessDecider() {
        return this.successDecider;
    }

    @Override
    public boolean hasFurtherAttack() {
        return this.hasFurtherAttack;
    }

    @Override
    public synchronized AttackModel nextAttack() {
        this.hasFurtherAttack = false;
        return this.currentAttack;
    }

    @Override
    public synchronized void update(AttackModel attackModel) {
        this.doSState.update(this, attackModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTestProbes(Metric metric) {
        this.doSState.updateTestProbes(metric);
        DoSState doSState = this.doSState;
        synchronized (doSState) {
            this.testProbeStatisticsShort.addValue((double)metric.getDuration());
            this.testProbeStatisticsLong.addValue((double)metric.getDuration());
        }
    }

    @Override
    public List<SuccessfulAttack> getSuccessfulAttacks() {
        return new ArrayList<SuccessfulAttack>(this.successfulAttackList);
    }

    @Override
    public List<DoSAttack> getNotPossible() {
        return new ArrayList<DoSAttack>(this.notPossibleList);
    }

    @Override
    public List<Threshold> getThresholds() {
        return new ArrayList<Threshold>(this.thresholdList);
    }

    private AttackModel createFirstAttack() {
        if (this.currentDoSAttack.hasFurtherParams()) {
            this.currentDoSAttack.nextParam();
        }
        this.commonParamsIterator = this.createCommonParamsIterator();
        this.currentCommonParams = this.commonParamsIterator.next();
        return this.createNewUntampered(false);
    }

    AttackModel createNextAttack() {
        return this.createNextAttack(false);
    }

    AttackModel createNextAttack(boolean needRecovery) {
        do {
            this.iterate();
        } while (!this.noFurtherIterations && this.isNotWise());
        AttackModel attack = null;
        if (!this.noFurtherIterations) {
            if (this.currentUntampered == null) {
                attack = this.createNewUntampered(needRecovery || this.m_needRecovery);
                this.m_needRecovery = false;
            } else {
                attack = this.createNewTampered(needRecovery);
            }
        }
        return attack;
    }

    private boolean isNotWise() {
        boolean wise = false;
        if (this.currentPosition == null) {
            return true;
        }
        for (DoSAttack doSAttack : this.notPossibleList) {
            if (!this.currentDoSAttack.getName().equals(doSAttack.getName())) continue;
            return true;
        }
        if (this.maximumRequestsPerSecond > 0.0 && this.currentCommonParams.getReuqestsPerSecond() > this.maximumRequestsPerSecond) {
            return true;
        }
        for (Threshold threshold : this.thresholdList) {
            if (!this.currentDoSAttack.getName().equals(threshold.getMinimum().getName()) || this.currentDoSAttack.compareTo(threshold.getMinimum()) <= 0) continue;
            return true;
        }
        for (SuccessfulAttack successfulAttack : this.successfulAttackList) {
            if (!this.currentPosition.equals(successfulAttack.getPosition()) || this.currentPayloadPosition != successfulAttack.getPayloadPosition() || !this.currentDoSAttack.equals(successfulAttack.getDoSAttack())) continue;
            return true;
        }
        return wise;
    }

    private void iterate() {
        if (this.commonParamsIterator.hasNext()) {
            this.currentCommonParams = this.commonParamsIterator.next();
        } else if (this.positionIterator.hasNext(this.currentPayloadPosition)) {
            this.commonParamsIterator = this.createCommonParamsIterator();
            this.currentPosition = this.positionIterator.next(this.currentPayloadPosition);
            this.currentCommonParams = this.commonParamsIterator.next();
        } else if (this.payloadPositionIterator.hasNext()) {
            this.commonParamsIterator = this.createCommonParamsIterator();
            this.positionIterator.reset();
            this.currentPayloadPosition = this.payloadPositionIterator.next();
            this.currentPosition = this.positionIterator.next(this.currentPayloadPosition);
            this.currentCommonParams = this.commonParamsIterator.next();
        } else if (this.currentDoSAttack.hasFurtherParams()) {
            this.commonParamsIterator = this.createCommonParamsIterator();
            this.positionIterator.reset();
            this.payloadPositionIterator = Arrays.asList(this.currentDoSAttack.getPossiblePossitions()).iterator();
            this.currentDoSAttack.nextParam();
            this.position();
            this.currentCommonParams = this.commonParamsIterator.next();
            this.currentUntampered = null;
        } else if (this.attackIterator.hasNext()) {
            this.commonParamsIterator = this.createCommonParamsIterator();
            this.positionIterator.reset();
            this.currentDoSAttack = this.attackIterator.next();
            LOG.info((Object)("start with " + this.currentDoSAttack.getName()));
            this.payloadPositionIterator = Arrays.asList(this.currentDoSAttack.getPossiblePossitions()).iterator();
            this.currentDoSAttack.nextParam();
            this.position();
            this.currentCommonParams = this.commonParamsIterator.next();
            this.currentUntampered = null;
            this.m_needRecovery = true;
        } else {
            this.noFurtherIterations = true;
        }
    }

    private void position() {
        this.currentPosition = null;
        while (this.payloadPositionIterator.hasNext() && this.currentPosition == null) {
            this.currentPayloadPosition = this.payloadPositionIterator.next();
            if (!this.positionIterator.hasNext(this.currentPayloadPosition)) continue;
            this.currentPosition = this.positionIterator.next(this.currentPayloadPosition);
        }
    }

    AttackModel createNewTampered(boolean needRecovery) {
        AttackModel attackModel = this.createAttack(RequestType.TAMPERED, this.currentCommonParams, needRecovery);
        String xmlWithPlaceholder = this.currentPosition.createPlaceholder(this.currentPayloadPosition);
        String content = this.currentDoSAttack.getTamperedRequest(xmlWithPlaceholder, this.currentPayloadPosition);
        attackModel.setRequestContent(content);
        attackModel.setPayloadPosition(this.currentPayloadPosition);
        attackModel.setPosition(this.currentPosition);
        return attackModel;
    }

    AttackModel createNewTampered(DoSAttack doSAttack) {
        AttackModel attackModel = this.createAttack(RequestType.TAMPERED, this.currentCommonParams, false);
        attackModel.setDoSAttack(doSAttack);
        String xmlWithPlaceholder = this.currentPosition.createPlaceholder(this.currentPayloadPosition);
        String content = doSAttack.getTamperedRequest(xmlWithPlaceholder, this.currentPayloadPosition);
        attackModel.setRequestContent(content);
        attackModel.setPayloadPosition(this.currentPayloadPosition);
        attackModel.setPosition(this.currentPosition);
        return attackModel;
    }

    AttackModel createNewUntampered(DoSAttack doSAttack) {
        AttackModel attackModel = this.createAttack(RequestType.UNTAMPERED, this.currentCommonParams, false);
        attackModel.setDoSAttack(doSAttack);
        String xmlWithPlaceholder = this.currentPosition.createPlaceholder(this.currentPayloadPosition);
        String content = doSAttack.getUntamperedRequest(xmlWithPlaceholder, this.currentPayloadPosition);
        attackModel.setRequestContent(content);
        attackModel.setPayloadPosition(this.currentPayloadPosition);
        attackModel.setPosition(this.currentPosition);
        return attackModel;
    }

    AttackModel createNewUntampered(boolean needRecovery) {
        CommonParamItem utr = new CommonParamItem(8, 4, 750);
        AttackModel attackModel = this.createNewUntampered(needRecovery, utr);
        return attackModel;
    }

    AttackModel createVerifyUntampered(boolean needRecovery) {
        AttackModel attackModel = this.createNewUntampered(needRecovery, this.currentCommonParams);
        return attackModel;
    }

    private AttackModel createNewUntampered(boolean needRecovery, CommonParamItem utr) {
        AttackModel attackModel = this.createAttack(RequestType.UNTAMPERED, utr, needRecovery);
        String xmlWithPlaceholder = this.currentPosition.createPlaceholder(this.currentPayloadPosition);
        String content = this.currentDoSAttack.getUntamperedRequest(xmlWithPlaceholder, this.currentPayloadPosition);
        attackModel.setRequestContent(content);
        return attackModel;
    }

    private AttackModel createAttack(RequestType requestType, CommonParamItem commonParams, boolean needRecovery) {
        AttackModel attackModel = new AttackModel();
        attackModel.setRequestType(requestType);
        try {
            attackModel.setDoSAttack(this.currentDoSAttack.clone());
        }
        catch (CloneNotSupportedException e) {
            LOG.info((Object)e.getMessage(), (Throwable)e);
        }
        attackModel.setParamItem(commonParams);
        if (needRecovery) {
            attackModel.setServerRecoveryBeforeSend(this.serverRecovery);
        }
        return attackModel;
    }

    @Override
    public boolean wasSuccessful() {
        return this.successfulAttackList.size() > 0;
    }

    @Override
    public String getTestProbeContent() {
        return this.xmlMessage;
    }

    private Iterator<CommonParamItem> createCommonParamsIterator() {
        return this.commonParamList.iterator();
    }

    public Long[] getCurrentUntampered() {
        Long[] copy = new Long[this.currentUntampered.length];
        System.arraycopy(this.currentUntampered, 0, copy, 0, this.currentUntampered.length);
        return copy;
    }

    void setCurrentUntampered(Long[] currentUntampered) {
        this.currentUntampered = currentUntampered;
        this.untamperedStatistics.clear();
        for (Long value : currentUntampered) {
            this.untamperedStatistics.addValue((double)value.longValue());
        }
    }

    boolean addSuccessful(SuccessfulAttack successfulAttack) {
        LOG.info((Object)("successful: " + successfulAttack));
        return this.successfulAttackList.add(successfulAttack);
    }

    void addNotPossible(DoSAttack doSAttack) {
        LOG.info((Object)(doSAttack.getName() + " is not possible against this Web Service"));
        this.notPossibleList.add(doSAttack);
    }

    @Override
    public double getMaximumRequestsPerSecond() {
        return this.maximumRequestsPerSecond;
    }

    void setMaximumRequestsPerSecond(double maximumRequestsPerSecond) {
        double fmrps = (double)((int)(maximumRequestsPerSecond * 100.0)) / 100.0;
        LOG.info((Object)("Threshold detected by " + fmrps + " requests per second."));
        this.maximumRequestsPerSecond = maximumRequestsPerSecond;
    }

    void addThreshold(Threshold threshold) {
        LOG.info((Object)String.format("Threshold detected for %s", threshold.getMinimum().getName()));
        List<DoSParam<?>> minParams = threshold.getMinimum().getCurrentParams();
        List<DoSParam<?>> maxParams = threshold.getMaximum().getCurrentParams();
        for (int index = 0; index < minParams.size(); ++index) {
            DoSParam<?> minParam = minParams.get(index);
            DoSParam<?> maxParam = maxParams.get(index);
            if (minParam.getValueAsString().equals(maxParam.getValueAsString())) continue;
            LOG.info((Object)(" -> " + minParam.getDescription() + " " + minParam.getValueAsString() + " - " + maxParam.getValueAsString()));
        }
        this.thresholdList.add(threshold);
    }

    public static IDoSBuilder create() {
        return new IDoSBuilder();
    }

    static {
        for (int[] commonParam : DEFAULTCOMMONPARAMS = (int[][])new int[][]{{16, 2, 750}, {16, 2, 500}, {24, 4, 500}, {24, 4, 250}, {32, 8, 250}, {128, 8, 250}}) {
            COMMONPARAMS.add(new CommonParamItem(commonParam));
        }
        LOG = Logger.getLogger(IntelligentDoSLibraryImpl.class);
    }

    public static class IDoSBuilder {
        private int serverRecoveryTime;
        private String xmlMessage;
        private PositionIterator positionIterator;
        private SuccessDecider successDecider;
        private DoSAttack[] dosAttackArray;
        private List<CommonParamItem> commonParamList;

        private IDoSBuilder() {
        }

        public IDoSBuilder withXmlMessage(String xmlMessage) {
            this.xmlMessage = xmlMessage;
            return this;
        }

        public IDoSBuilder withPositionIterator(PositionIterator positionIterator) {
            this.positionIterator = positionIterator;
            return this;
        }

        public IDoSBuilder withAttacks(DoSAttack[] dosAttackArray) {
            this.dosAttackArray = new DoSAttack[dosAttackArray.length];
            System.arraycopy(dosAttackArray, 0, this.dosAttackArray, 0, dosAttackArray.length);
            return this;
        }

        public IDoSBuilder withSuccessDecider(SuccessDecider successDecider) {
            this.successDecider = successDecider;
            return this;
        }

        public IDoSBuilder withCommonParams(List<CommonParamItem> commonParamList) {
            this.commonParamList = commonParamList;
            return this;
        }

        public IDoSBuilder withServerRecoveryTime(int serverRecoveryTime) {
            this.serverRecoveryTime = serverRecoveryTime;
            return this;
        }

        public IntelligentDoSLibrary build() {
            IntelligentDoSLibraryImpl intelligentDoSLibraryImpl = new IntelligentDoSLibraryImpl(this.xmlMessage, this.positionIterator);
            intelligentDoSLibraryImpl.setAttacks(this.dosAttackArray);
            intelligentDoSLibraryImpl.setSuccessDecider(this.successDecider);
            intelligentDoSLibraryImpl.setCommonParams(this.commonParamList);
            intelligentDoSLibraryImpl.setServerRecoveryTime(this.serverRecoveryTime);
            return intelligentDoSLibraryImpl;
        }
    }
}

