/*
 * Decompiled with CFR 0.152.
 */
import com.eviware.soapui.analytics.ActionDescription;
import com.eviware.soapui.analytics.providers.BaseAnalyticsProvider;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class GoogleAnalyticsProvider
extends BaseAnalyticsProvider {
    private static final Logger log = Logger.getLogger(GoogleAnalyticsProvider.class);
    private static final String GA_ID = "UA-92447-17";
    private static final String CATEGORY_SESSION = "Session";
    private static final String CATEGORY_ACTION = "Action";
    private static final String CATEGORY_PGU_IN = "Plug-in";
    private static final String CATEGORY_INVALID = "[Unknown]";
    private static final String EVENT_START = "Start";
    private static final String EVENT_STOP = "Stop";
    private static final String EVENT_CUSTOM = "Custom";
    private static final String EVENT_INVALID = "[Unknown]";
    private static final String NO_MAC_ADDRESS = "MacAddressUnreachable";
    private static final String NO_ACTIVE_SCREEN = "NoActiveScreen";

    public void trackAction(ActionDescription actionDescription) {
        try {
            this.sendRecord(this.buildParametersString(actionDescription));
            this.trackActiveScreen(actionDescription.getActionName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String urlEncodeWithUtf8(String input) {
        try {
            return URLEncoder.encode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Unexpected error: charset UTF-8 not available", e);
        }
    }

    String buildParametersString(ActionDescription actionDescription) throws SocketException, UnknownHostException {
        String gaParametersString = String.format("v=1&an=%s&av=%s&cd=%s&tid=%s&cid=%s&t=event&ec=%s&ea=%s&el=%s&ev=1&sr=%s&cm1=%s&aip=1", GoogleAnalyticsProvider.urlEncodeWithUtf8("SoapUI-pro"), GoogleAnalyticsProvider.urlEncodeWithUtf8(this.getSoapUIVersion()), "undefined", GA_ID, GoogleAnalyticsProvider.getMacAddressString(), GoogleAnalyticsProvider.urlEncodeWithUtf8(this.getEventCategory(actionDescription)), GoogleAnalyticsProvider.urlEncodeWithUtf8(this.getEventAction(actionDescription)), GoogleAnalyticsProvider.urlEncodeWithUtf8(this.getEventLabel(actionDescription)), this.getStrScreenSize(), GoogleAnalyticsProvider.urlEncodeWithUtf8(actionDescription.getSessionId()));
        switch (actionDescription.getCategory()) {
            case SESSION_START: {
                gaParametersString = gaParametersString + "&sc=start&ua=" + GoogleAnalyticsProvider.urlEncodeWithUtf8("SoapUI-pro/" + this.getSoapUIVersion() + " (" + this.getOsName() + " " + this.getOsVersion() + ")");
                break;
            }
            case SESSION_STOP: {
                gaParametersString = gaParametersString + "&sc=end";
            }
        }
        return gaParametersString;
    }

    private static String getMacAddressString() {
        try {
            NetworkInterface network = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
            if (network == null) {
                return NO_MAC_ADDRESS;
            }
            byte[] mac = network.getHardwareAddress();
            StringBuilder sb = new StringBuilder();
            for (byte aMac : mac) {
                sb.append(String.format("%d", aMac));
            }
            return sb.toString();
        }
        catch (IOException e) {
            log.warn((Object)"Couldn't determine MAC address - returning empty String");
            return NO_MAC_ADDRESS;
        }
    }

    private HttpURLConnection initializeConnection() {
        try {
            URL url = new URL("http://www.google-analytics.com/collect");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            return connection;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void trackActiveScreen(String screenName) {
        try {
            NetworkInterface network = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
            StringBuilder sb = new StringBuilder();
            if (network != null) {
                byte[] mac = network.getHardwareAddress();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%d", mac[i]));
                }
            } else {
                sb.append(NO_ACTIVE_SCREEN);
            }
            String gaParametersString = String.format("v=1&an=%s&av=%s&cd=%s&tid=%s&cid=%s&t=screenview&cd=%s&sr=%s", GoogleAnalyticsProvider.urlEncodeWithUtf8("SoapUI-pro"), GoogleAnalyticsProvider.urlEncodeWithUtf8(this.getSoapUIVersion()), "undefined", GA_ID, sb.toString(), GoogleAnalyticsProvider.urlEncodeWithUtf8(screenName), this.getStrScreenSize());
            this.sendRecord(gaParametersString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private boolean sendRecord(String parameters) {
        if (parameters == null) {
            return false;
        }
        HttpURLConnection connection = this.initializeConnection();
        if (connection == null) {
            return false;
        }
        try {
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(parameters);
            wr.flush();
            wr.close();
            int responseCode = connection.getResponseCode();
            return responseCode == 200;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private String getEventCategory(ActionDescription actionDescription) {
        switch (actionDescription.getCategory()) {
            case SESSION_START: 
            case SESSION_STOP: {
                return CATEGORY_SESSION;
            }
            case ACTION: {
                return CATEGORY_ACTION;
            }
            case CUSTOM_PLUGIN_ACTION: {
                return CATEGORY_PGU_IN;
            }
        }
        return "[Unknown]";
    }

    private String getEventAction(ActionDescription actionDescription) {
        switch (actionDescription.getCategory()) {
            case SESSION_START: {
                return EVENT_START;
            }
            case SESSION_STOP: {
                return EVENT_STOP;
            }
            case ACTION: {
                return actionDescription.getActionName();
            }
            case CUSTOM_PLUGIN_ACTION: {
                return EVENT_CUSTOM;
            }
        }
        return "[Unknown]";
    }

    private String getEventLabel(ActionDescription actionDescription) {
        switch (actionDescription.getCategory()) {
            case SESSION_START: {
                return String.format("%s %s, %s; License: %s", this.getOsName(), this.getOsVersion(), this.getStrScreenSize(), this.getLicenseDescription());
            }
        }
        return actionDescription.getParamsAsString();
    }
}

