/*
 * Decompiled with CFR 0.152.
 */
package skt.swing.tree.check;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import skt.swing.tree.check.CheckTreeSelectionModel;
import skt.swing.tree.check.TreePathSelectable;
import skt.swing.tree.check.TristateCheckBox;

public class CheckTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    private CheckTreeSelectionModel selectionModel;
    private TreePathSelectable selectable;
    private TreeCellRenderer delegate;
    private TristateCheckBox checkBox = new TristateCheckBox();

    public CheckTreeCellRenderer(TreeCellRenderer delegate, CheckTreeSelectionModel selectionModel, TreePathSelectable selectable) {
        this.delegate = delegate;
        this.selectionModel = selectionModel;
        this.selectable = selectable;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.checkBox.setOpaque(false);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component renderer = this.delegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        TreePath path = tree.getPathForRow(row);
        if (path != null) {
            if (this.selectionModel.isPathSelected(path, this.selectionModel.isDigged())) {
                this.checkBox.setState(Boolean.TRUE);
            } else {
                this.checkBox.setState((Boolean)(this.selectionModel.isDigged() && this.selectionModel.isPartiallySelected(path) ? null : Boolean.FALSE));
            }
        }
        this.removeAll();
        this.checkBox.setVisible(path == null || this.selectable == null || this.selectable.isSelectable(path));
        this.add((Component)this.checkBox, "West");
        this.add(renderer, "Center");
        return this;
    }
}

