/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.x.impl.swing;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.DefaultActionList;
import com.eviware.soapui.support.components.JButtonBar;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.ValidationMessage;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormField;
import com.eviware.x.impl.swing.AbstractSwingXFormField;
import com.eviware.x.impl.swing.SwingXFormDialog;
import com.eviware.x.impl.swing.SwingXFormImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class JTabbedFormDialog
extends SwingXFormDialog {
    private JDialog dialog;
    private List<SwingXFormImpl> forms = new ArrayList<SwingXFormImpl>();
    private JTabbedPane tabs;
    private JButtonBar buttons;

    public JTabbedFormDialog(String name, XForm[] forms, ActionList actions, String description, ImageIcon icon) {
        this.dialog = new JDialog(UISupport.getMainFrame(), name, true);
        this.tabs = new JTabbedPane();
        for (XForm form : forms) {
            SwingXFormImpl swingFormImpl = (SwingXFormImpl)form;
            this.forms.add(swingFormImpl);
            JPanel panel = swingFormImpl.getPanel();
            panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            this.tabs.addTab(form.getName(), panel);
        }
        this.buttons = UISupport.initDialogActions(actions, this.dialog);
        if (description != null || icon != null) {
            this.dialog.getContentPane().add((Component)UISupport.buildDescription(name, description, icon), "North");
        }
        this.dialog.getContentPane().add((Component)UISupport.createTabPanel(this.tabs, false), "Center");
        this.buttons.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        this.dialog.getContentPane().add((Component)this.buttons, "South");
        this.dialog.pack();
        Dimension size = this.dialog.getSize();
        if (size.getHeight() < 300.0) {
            this.dialog.setSize(new Dimension((int)size.getWidth(), 300));
        }
    }

    @Override
    public void setSize(int i, int j) {
        this.dialog.setSize(i, j);
    }

    @Override
    public XForm[] getForms() {
        ArrayList<XForm> result = new ArrayList<XForm>();
        for (XForm xForm : this.forms) {
            result.add(xForm);
        }
        return result.toArray(new XForm[result.size()]);
    }

    @Override
    public void setValues(StringToStringMap values) {
        for (XForm xForm : this.forms) {
            xForm.setValues(values);
        }
    }

    @Override
    public void setOptions(String field, Object[] options) {
        for (XForm xForm : this.forms) {
            xForm.setOptions(field, options);
        }
    }

    @Override
    public XFormField getFormField(String name) {
        for (XForm xForm : this.forms) {
            XFormField formField = xForm.getFormField(name);
            if (formField == null) continue;
            return formField;
        }
        return null;
    }

    @Override
    public void addAction(Action action) {
        DefaultActionList actions = new DefaultActionList();
        actions.addAction(action);
        this.buttons.addActions(actions);
    }

    @Override
    public StringToStringMap getValues() {
        StringToStringMap result = new StringToStringMap();
        for (XForm xForm : this.forms) {
            result.putAll(xForm.getValues());
        }
        return result;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.tabs.setSelectedIndex(0);
        }
        UISupport.centerDialog(this.dialog);
        this.dialog.setVisible(visible);
    }

    @Override
    public boolean validate() {
        for (int i = 0; i < this.forms.size(); ++i) {
            XFormField[] formFields = this.forms.get(i).getFormFields();
            for (int c = 0; c < formFields.length; ++c) {
                ValidationMessage[] messages = formFields[c].validate();
                if (messages == null || messages.length <= 0) continue;
                this.tabs.setSelectedIndex(i);
                ((JComponent)((AbstractSwingXFormField)messages[0].getFormField()).getComponent()).requestFocus();
                UISupport.showErrorMessage(messages[0].getMessage());
                return false;
            }
        }
        return true;
    }

    @Override
    public void setFormFieldProperty(String name, Object value) {
        for (XForm xForm : this.forms) {
            xForm.setFormFieldProperty(name, value);
        }
    }

    @Override
    public String getValue(String field) {
        for (XForm xForm : this.forms) {
            if (xForm.getComponent(field) == null) continue;
            return xForm.getComponent(field).getValue();
        }
        return null;
    }

    @Override
    public void setValue(String field, String value) {
        for (XForm xForm : this.forms) {
            if (xForm.getComponent(field) == null) continue;
            xForm.getComponent(field).setValue(value);
        }
    }

    @Override
    public int getValueIndex(String name) {
        for (SwingXFormImpl form : this.forms) {
            if (form.getComponent(name) == null) continue;
            Object[] options = form.getOptions(name);
            if (options == null) {
                return -1;
            }
            return Arrays.asList(options).indexOf(form.getComponentValue(name));
        }
        return -1;
    }

    @Override
    public boolean show() {
        this.setReturnValue(2);
        this.show(new StringToStringMap());
        return this.getReturnValue() == 1;
    }

    @Override
    public void setWidth(int i) {
        this.dialog.setPreferredSize(new Dimension(i, (int)this.dialog.getPreferredSize().getHeight()));
    }

    @Override
    public void release() {
        this.dialog.dispose();
        this.tabs.removeAll();
        this.dialog = null;
        this.tabs = null;
    }

    public JComponent getTabs() {
        return this.tabs;
    }

    public void setResizable(boolean b) {
        this.dialog.setResizable(b);
    }
}

