/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.ui.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.model.tree.nodes.support.EmptyModelItem;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;

public abstract class ModelItemDesktopPanel<T extends ModelItem>
extends JPanel
implements DesktopPanel,
PropertyChangeListener {
    private final T modelItem;

    public ModelItemDesktopPanel(T modelItem) {
        super(new BorderLayout());
        this.modelItem = modelItem;
        modelItem.addPropertyChangeListener(this);
    }

    protected boolean release() {
        this.modelItem.removePropertyChangeListener(this);
        return true;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public final T getModelItem() {
        return this.modelItem;
    }

    @Override
    public Icon getIcon() {
        return this.modelItem.getIcon();
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return ModelSupport.dependsOn(this.getModelItem(), modelItem);
    }

    @Override
    public String getTitle() {
        return this.modelItem.getName();
    }

    @Override
    public final String getDescription() {
        TreePath treePath = SoapUI.getNavigator().getTreePath((ModelItem)this.modelItem);
        if (treePath == null) {
            return this.modelItem.getDescription();
        }
        String str = this.modelItem.getName() + " [";
        for (int c = 1; c < treePath.getPathCount(); ++c) {
            SoapUITreeNode comp = (SoapUITreeNode)treePath.getPathComponent(c);
            if (comp.getModelItem() instanceof EmptyModelItem) continue;
            if (c > 1) {
                str = str + "/";
            }
            str = str + comp.toString();
        }
        str = str + "]";
        return str;
    }

    public static JButton createActionButton(Action action, boolean enabled) {
        JButton button = UISupport.createToolbarButton(action, enabled);
        action.putValue("Name", null);
        return button;
    }

    public void notifyPropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(ModelItem.NAME_PROPERTY)) {
            this.notifyPropertyChange(DesktopPanel.TITLE_PROPERTY, null, this.getTitle());
        }
        if (evt.getPropertyName().equals(ModelItem.ICON_PROPERTY)) {
            this.notifyPropertyChange(DesktopPanel.ICON_PROPERTY, null, this.getIcon());
        }
    }

    @Override
    public boolean onClose(boolean canCancel) {
        return this.release();
    }
}

