/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.types;

import com.eviware.soapui.config.StringListConfig;
import com.eviware.soapui.support.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.xmlbeans.XmlException;

public class StringList
extends ArrayList<String> {
    public StringList() {
    }

    public StringList(int initialCapacity) {
        super(initialCapacity);
    }

    public StringList(String[] strings) {
        super(strings == null ? new StringList() : Arrays.asList(strings));
    }

    public StringList(Object[] objects) {
        if (objects != null) {
            for (Object object : objects) {
                this.add(object == null ? null : object.toString());
            }
        }
    }

    public StringList(Collection<?> objects) {
        if (objects != null) {
            for (Object object : objects) {
                this.add(object == null ? null : object.toString());
            }
        }
    }

    public StringList(String paramStr) {
        this();
        this.add(paramStr);
    }

    public void addAll(String[] strings) {
        if (strings != null && strings.length > 0) {
            this.addAll(Arrays.asList(strings));
        }
    }

    public String[] toStringArray() {
        return this.toArray(new String[this.size()]);
    }

    public static StringList fromXml(String value) throws XmlException {
        return StringUtils.isNullOrEmpty(value) || value.equals("<xml-fragment/>") ? new StringList() : new StringList((Collection<?>)StringListConfig.Factory.parse(value).getEntryList());
    }

    public String toXml() {
        StringListConfig config = StringListConfig.Factory.newInstance();
        config.setEntryArray(this.toStringArray());
        return config.xmlText();
    }

    public boolean containsValue(String value) {
        for (String stringElement : this) {
            if (!stringElement.contains(value)) continue;
            return true;
        }
        return false;
    }
}

