/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.script;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditor;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditorModel;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.editor.EditorView;
import com.eviware.soapui.support.editor.inspectors.AbstractXmlInspector;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import com.eviware.soapui.support.xml.XmlUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MockResponseScriptInspector
extends AbstractXmlInspector {
    private final MockResponse mockResponse;
    private GroovyEditor responseScriptEditor;
    private RunScriptAction runScriptAction = new RunScriptAction();
    private JPanel panel;

    protected MockResponseScriptInspector(MockResponse mockResponse) {
        super("Script", "Script for this MockResponse", true, "Script");
        this.mockResponse = mockResponse;
    }

    @Override
    public JComponent getComponent() {
        if (this.panel == null) {
            this.buildResponseScriptEditor();
        }
        return this.panel;
    }

    @Override
    public void activate() {
        this.responseScriptEditor.requestFocusInWindow();
    }

    protected void buildResponseScriptEditor() {
        this.responseScriptEditor = new GroovyEditor(new MockResponseGroovyEditorModel());
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)this.buildScriptToolbar(), "North");
        this.panel.add((Component)this.responseScriptEditor, "Center");
    }

    private JComponent buildScriptToolbar() {
        JXToolBar toolBar = UISupport.createToolbar();
        JButton runButton = UISupport.createToolbarButton(this.runScriptAction);
        toolBar.add(runButton);
        toolBar.add(Box.createHorizontalGlue());
        JLabel label = new JLabel("<html>Script is invoked with <code>log</code>, <code>context</code>, <code>requestContext</code>, <code>mockRequest</code> and <code>mockResponse</code> variables</html>");
        label.setToolTipText(label.getText());
        label.setMaximumSize(label.getPreferredSize());
        toolBar.add(label);
        toolBar.addUnrelatedGap();
        toolBar.addFixed(UISupport.createActionButton(new ShowOnlineHelpAction(this.mockResponse.getScriptHelpUrl()), true));
        return toolBar;
    }

    @Override
    public void release() {
        super.release();
        this.responseScriptEditor.release();
    }

    @Override
    public boolean isEnabledFor(EditorView<XmlDocument> view) {
        return true;
    }

    private class MockResponseGroovyEditorModel
    implements GroovyEditorModel {
        private MockResponseGroovyEditorModel() {
        }

        @Override
        public String[] getKeywords() {
            return new String[]{"context", "mockRequest", "mockResponse", "log", "requestContext"};
        }

        @Override
        public Action getRunAction() {
            return MockResponseScriptInspector.this.runScriptAction;
        }

        @Override
        public String getScript() {
            return MockResponseScriptInspector.this.mockResponse.getScript();
        }

        @Override
        public void setScript(String text) {
            MockResponseScriptInspector.this.mockResponse.setScript(text);
        }

        @Override
        public Settings getSettings() {
            return SoapUI.getSettings();
        }

        @Override
        public String getScriptName() {
            return null;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public ModelItem getModelItem() {
            return MockResponseScriptInspector.this.mockResponse;
        }
    }

    private class RunScriptAction
    extends AbstractAction {
        public RunScriptAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run_groovy_script.gif"));
            this.putValue("ShortDescription", "Runs this script using mock httpRequest/httpResponse objects");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                MockResult mockResult = MockResponseScriptInspector.this.mockResponse.getMockResult();
                MockResponseScriptInspector.this.mockResponse.evaluateScript(mockResult == null ? null : mockResult.getMockRequest());
                HashMap values = null;
                if (MockResponseScriptInspector.this.mockResponse.getMockResult() != null) {
                    values = MockResponseScriptInspector.this.mockResponse.getMockResult().getMockRequest().getContext().toStringToStringMap();
                }
                if (values == null || values.isEmpty()) {
                    UISupport.showInfoMessage("No values were returned");
                } else {
                    String msg = "<html><body>Returned values:<br>";
                    for (String name : values.keySet()) {
                        msg = msg + XmlUtils.entitize(name) + " : " + XmlUtils.entitize((String)values.get(name)) + "<br>";
                    }
                    msg = msg + "</body></html>";
                    UISupport.showExtendedInfo("Result", "Result of MockResponse Script", msg, new Dimension(500, 400));
                }
            }
            catch (Throwable e1) {
                MockResponseScriptInspector.this.responseScriptEditor.selectError(e1.getMessage());
                UISupport.showErrorMessage(e1.toString());
            }
        }
    }
}

