/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.auth;

import com.eviware.soapui.config.CredentialsConfig;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.support.components.SimpleBindingForm;
import com.eviware.soapui.support.editor.inspectors.auth.AbstractAuthenticationForm;
import com.jgoodies.binding.PresentationModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class BasicAuthenticationForm<T extends AbstractHttpRequest>
extends AbstractAuthenticationForm {
    protected T request;
    private JRadioButton globalButton;
    private JRadioButton preemptiveButton;

    public BasicAuthenticationForm(T request) {
        this.request = request;
    }

    @Override
    protected JPanel buildUI() {
        SimpleBindingForm basicAuthenticationForm = new SimpleBindingForm(new PresentationModel(this.request));
        this.populateBasicForm(basicAuthenticationForm);
        JPanel panel = basicAuthenticationForm.getPanel();
        this.setBorderAndBackgroundColorOnPanel(panel);
        return panel;
    }

    public void setButtonGroupVisibility(boolean visible) {
        this.globalButton.setVisible(visible);
        this.preemptiveButton.setVisible(visible);
    }

    protected void populateBasicForm(SimpleBindingForm basicConfigurationForm) {
        this.initForm(basicConfigurationForm);
        basicConfigurationForm.addSpace(10);
        basicConfigurationForm.appendTextField("username", "Username", "The username to use for HTTP Authentication");
        basicConfigurationForm.appendPasswordField("password", "Password", "The password to use for HTTP Authentication");
        basicConfigurationForm.appendTextField("domain", "Domain", "The domain to use for Authentication(NTLM/Kerberos)");
        ButtonGroup buttonGroup = new ButtonGroup();
        this.globalButton = basicConfigurationForm.appendRadioButton("Pre-emptive auth", "Use global preference", buttonGroup, false);
        this.globalButton.setBackground(CARD_BACKGROUND_COLOR);
        this.preemptiveButton = basicConfigurationForm.appendRadioButton("", "Authenticate pre-emptively", buttonGroup, false);
        this.preemptiveButton.setBackground(CARD_BACKGROUND_COLOR);
        this.selectCorrectRadioButton();
        this.globalButton.addActionListener(new UseGlobalSettingsRadioButtonListener(this.globalButton));
        this.preemptiveButton.addActionListener(new PreemptiveRadioButtonListener(this.preemptiveButton));
    }

    private void selectCorrectRadioButton() {
        if (((AbstractHttpRequest)this.request).getPreemptive()) {
            this.preemptiveButton.setSelected(true);
        } else {
            this.globalButton.setSelected(true);
        }
    }

    private class UseGlobalSettingsRadioButtonListener
    implements ActionListener {
        private final JRadioButton globalButton;

        public UseGlobalSettingsRadioButtonListener(JRadioButton globalButton) {
            this.globalButton = globalButton;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.globalButton.isSelected()) {
                ((AbstractHttpRequest)BasicAuthenticationForm.this.request).setSelectedAuthProfileAndAuthType("Basic", CredentialsConfig.AuthType.GLOBAL_HTTP_SETTINGS);
                ((AbstractHttpRequest)BasicAuthenticationForm.this.request).setPreemptive(false);
            }
        }
    }

    private class PreemptiveRadioButtonListener
    implements ActionListener {
        private final JRadioButton preemptiveButton;

        public PreemptiveRadioButtonListener(JRadioButton preemptiveButton) {
            this.preemptiveButton = preemptiveButton;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.preemptiveButton.isSelected()) {
                ((AbstractHttpRequest)BasicAuthenticationForm.this.request).setSelectedAuthProfileAndAuthType("Basic", CredentialsConfig.AuthType.PREEMPTIVE);
                ((AbstractHttpRequest)BasicAuthenticationForm.this.request).setPreemptive(true);
            }
        }
    }
}

