/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.action.swing;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.SoapUIExtensionClassLoader;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.SoapUIAction;
import com.eviware.soapui.support.action.SoapUIActionMapping;
import com.eviware.soapui.support.action.SoapUIMultiAction;
import com.eviware.soapui.support.action.swing.SoapUIActionMarker;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;

public class SwingMultiActionDelegate
extends AbstractAction
implements PropertyChangeListener,
SoapUIActionMarker {
    private final SoapUIActionMapping<?> mapping;
    private ModelItem[] targets;

    public SwingMultiActionDelegate(SoapUIActionMapping<?> mapping, ModelItem[] targets) {
        super(mapping.getName());
        this.mapping = mapping;
        this.targets = targets;
        if (mapping.getDescription() != null) {
            this.putValue("ShortDescription", mapping.getDescription());
        }
        if (mapping.getIconPath() != null) {
            this.putValue("SmallIcon", UISupport.createImageIcon(mapping.getIconPath()));
        }
        if (mapping.getKeyStroke() != null) {
            this.putValue("AcceleratorKey", UISupport.getKeyStroke(mapping.getKeyStroke()));
        }
        this.setEnabled(mapping.getAction().isEnabled());
        String name = mapping.getName();
        int ix = name.indexOf(38);
        if (ix >= 0) {
            this.putValue("Name", name.substring(0, ix) + name.substring(ix + 1));
            this.putValue("MnemonicKey", new Integer(name.charAt(ix + 1)));
        }
    }

    public SoapUIActionMapping<?> getMapping() {
        return this.mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (SwingActionDelegate.switchClassloader) {
            SoapUIExtensionClassLoader.SoapUIClassLoaderState state = SoapUIExtensionClassLoader.ensure();
            try {
                ((SoapUIMultiAction)this.mapping.getAction()).perform(this.targets, this.mapping.getParam());
            }
            catch (Throwable t) {
                SoapUI.logError(t);
            }
            finally {
                state.restore();
            }
        } else {
            try {
                ((SoapUIMultiAction)this.mapping.getAction()).perform(this.targets, this.mapping.getParam());
            }
            catch (Throwable t) {
                SoapUI.logError(t);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(SoapUIAction.ENABLED_PROPERTY)) {
            this.setEnabled((Boolean)evt.getNewValue());
        }
    }

    public ModelItem[] getTargets() {
        return this.targets;
    }

    @Override
    public SoapUIAction<?> getSoapUIAction() {
        return this.mapping.getAction();
    }
}

