/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SoapUIVersionUpdate {
    static final String VERSION_UPDATE_URL_SYS_PROP_KEY = "versionUpdateUrl";
    static final String LATEST_VERSION_XML_LOCATION = SoapUIVersionUpdate.versionUpdateUrl("http://dl.eviware.com/version-update/soapui-version.xml");
    public static final String VERSION_TO_SKIP = SoapUI.class.getName() + "@versionToSkip";
    protected static final String NO_RELEASE_NOTES_INFO = "Sorry! No Release notes currently available.";
    private String latestVersion;
    private String releaseNotesCore;
    private String releaseNotesPro;
    private String downloadLinkCore;
    private String downloadLinkPro;

    public void getLatestVersionAvailable(String documentContent) throws Exception {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputStream inputStream = IOUtils.toInputStream((String)documentContent, (String)"UTF-8");
            Document doc = db.parse(inputStream);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getElementsByTagName("version");
            Node firstNode = nodeList.item(0);
            if (firstNode.getNodeType() == 1) {
                Element firstElement = (Element)firstNode;
                this.latestVersion = this.getNodeValue(firstElement, "version-number");
                this.releaseNotesCore = this.getNodeValue(firstElement, "release-notes-core");
                this.releaseNotesPro = this.getNodeValue(firstElement, "release-notes-pro");
                this.downloadLinkCore = this.getNodeValue(firstElement, "download-link-core");
                this.downloadLinkPro = this.getNodeValue(firstElement, "download-link-pro");
            }
        }
        catch (Exception e) {
            SoapUI.logError(e, "Network Error for Version Update or Proxy");
            throw e;
        }
    }

    private String getNodeValue(Element firstElement, String tagName) {
        NodeList elementList = firstElement.getElementsByTagName(tagName);
        Element element = (Element)elementList.item(0);
        NodeList nodes = element.getChildNodes();
        return nodes.item(0).getNodeValue();
    }

    private String fetchVersionDocumentContent(URL versionUrl) throws URISyntaxException, IOException {
        URLConnection connection = versionUrl.openConnection();
        InputStream inputStream = connection.getInputStream();
        String response = IOUtils.toString((InputStream)inputStream);
        inputStream.close();
        Authenticator.setDefault(null);
        return response;
    }

    private static String versionUpdateUrl(String defaultUrl) {
        return System.getProperty(VERSION_UPDATE_URL_SYS_PROP_KEY, defaultUrl);
    }

    private boolean isNewReleaseAvailable() {
        String latestVersion;
        int betaIndex;
        boolean isBeta;
        boolean isSnapshot;
        String currentSoapuiVersion = SoapUI.SOAPUI_VERSION;
        int snapshotIndex = currentSoapuiVersion.indexOf("SNAPSHOT");
        boolean bl = isSnapshot = snapshotIndex > 0;
        if (isSnapshot) {
            currentSoapuiVersion = currentSoapuiVersion.substring(0, snapshotIndex - 1);
        }
        boolean bl2 = isBeta = (betaIndex = currentSoapuiVersion.toUpperCase().indexOf("BETA")) > 0;
        if (isBeta) {
            currentSoapuiVersion = currentSoapuiVersion.substring(0, betaIndex - 1);
        }
        if (StringUtils.isNullOrEmpty(latestVersion = this.getLatestVersion())) {
            return false;
        }
        if (isSnapshot && currentSoapuiVersion.equals(latestVersion)) {
            return true;
        }
        if (isBeta && currentSoapuiVersion.equals(latestVersion)) {
            return true;
        }
        return currentSoapuiVersion.compareTo(latestVersion) < 0;
    }

    protected String getReleaseNotes() {
        return this.getReleaseNotesCore();
    }

    public String getReleaseNotesCore() {
        return this.releaseNotesCore;
    }

    public String getReleaseNotesPro() {
        return this.releaseNotesPro;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public void showNewVersionDownloadDialog() {
        JPanel versionUpdatePanel = new JPanel(new BorderLayout());
        JDialog dialog = new JDialog();
        versionUpdatePanel.add((Component)UISupport.buildDescription("New Version of SoapUI is Available", "", null), "North");
        JEditorPane text = this.createReleaseNotesPane();
        JScrollPane scb = new JScrollPane(text);
        versionUpdatePanel.add((Component)scb, "Center");
        JPanel toolbar = this.buildToolbar(dialog);
        versionUpdatePanel.add((Component)toolbar, "South");
        dialog.setTitle("New Version Update");
        dialog.setModal(true);
        dialog.getContentPane().add(versionUpdatePanel);
        dialog.setSize(new Dimension(500, 640));
        UISupport.centerDialog(dialog, SoapUI.getFrame());
        dialog.setVisible(true);
    }

    protected JEditorPane createReleaseNotesPane() {
        JEditorPane text = new JEditorPane();
        try {
            text.setPage(this.getReleaseNotes());
            text.setEditable(false);
            text.setBorder(BorderFactory.createLineBorder(Color.black));
        }
        catch (IOException e) {
            text.setText(NO_RELEASE_NOTES_INFO);
            SoapUI.logError(e);
        }
        return text;
    }

    protected JPanel buildToolbar(JDialog dialog) {
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        JPanel leftBtns = new JPanel();
        leftBtns.add(new JButton(new IgnoreUpdateAction(dialog)));
        leftBtns.add(new JButton(new RemindLaterAction(dialog)));
        JButton createToolbarButton = new JButton(new OpenDownloadUrlAction("Download latest version", this.getDownloadLinkCore(), dialog));
        JPanel rightBtn = new JPanel();
        rightBtn.add(createToolbarButton);
        toolbarPanel.add((Component)leftBtns, "West");
        toolbarPanel.add((Component)rightBtn, "East");
        return toolbarPanel;
    }

    public boolean skipThisVersion() {
        return SoapUI.getSettings().getString(VERSION_TO_SKIP, "").equals(this.getLatestVersion());
    }

    public void checkForNewVersion(final boolean helpAction) {
        try {
            String documentContent = this.fetchVersionDocumentContent(new URL(LATEST_VERSION_XML_LOCATION));
            this.getLatestVersionAvailable(documentContent);
        }
        catch (Exception e) {
            SoapUI.log(e.getMessage());
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SoapUIVersionUpdate.this.isNewReleaseAvailable() && (!SoapUIVersionUpdate.this.skipThisVersion() || helpAction)) {
                    SoapUIVersionUpdate.this.showNewVersionDownloadDialog();
                } else if (helpAction) {
                    UISupport.showInfoMessage("You are running the latest version of SoapUI!", "Version Check");
                }
            }
        });
    }

    protected String getDownloadLinkCore() {
        return this.downloadLinkCore;
    }

    protected String getDownloadLinkPro() {
        return this.downloadLinkPro;
    }

    public class OpenDownloadUrlAction
    extends AbstractAction {
        private final String url;
        private JDialog dialog;

        public OpenDownloadUrlAction(String title, String url, JDialog dialog) {
            super(title);
            this.url = url;
            this.dialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.url == null) {
                UISupport.showErrorMessage("Missing url");
            } else {
                Tools.openURL(this.url);
            }
            this.dialog.setVisible(false);
        }
    }

    protected class RemindLaterAction
    extends AbstractAction {
        private JDialog dialog;

        public RemindLaterAction(JDialog dialog) {
            super("Remind Me Later");
            this.dialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.dialog.setVisible(false);
        }
    }

    protected class IgnoreUpdateAction
    extends AbstractAction {
        private JDialog dialog;

        public IgnoreUpdateAction(JDialog dialog) {
            super("Ignore This Update");
            this.dialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SoapUI.getSettings().setString(VERSION_TO_SKIP, SoapUIVersionUpdate.this.getLatestVersion());
            this.dialog.setVisible(false);
        }
    }
}

