/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support;

import com.eviware.soapui.support.MutableValue;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.spi.Mode;
import com.jayway.jsonpath.spi.impl.AbstractJsonProvider;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.groovy.JsonSlurper;

public class PlainJavaJsonProvider
extends AbstractJsonProvider {
    private JsonSlurper jsonSlurper = new JsonSlurper();
    private Object valueToWrite;

    public void setValueToWrite(Object valueToWrite) {
        this.valueToWrite = valueToWrite;
    }

    public Mode getMode() {
        return Mode.SLACK;
    }

    public Object parse(String json) throws InvalidJsonException {
        return this.parse(new StringReader(json));
    }

    public Object parse(Reader jsonReader) throws InvalidJsonException {
        try {
            JSON jsonRoot = this.jsonSlurper.parse(jsonReader);
            Object converted = this.convertToPlainJavaImplementation(jsonRoot);
            return MutableValue.TO_MUTABLE_VALUE.apply(converted);
        }
        catch (Exception e) {
            throw new InvalidJsonException((Throwable)e);
        }
    }

    public Object parse(InputStream jsonStream) throws InvalidJsonException {
        return this.parse(new BufferedReader(new InputStreamReader(jsonStream)));
    }

    public String toJson(Object obj) {
        return ((JSON)obj).toString(3);
    }

    public Object createMap() {
        return new LinkedHashMap();
    }

    public Iterable createArray() {
        return new ArrayList();
    }

    public boolean isArray(Object obj) {
        return MutableValue.extractValueFromMutable(obj) instanceof List;
    }

    public boolean isContainer(Object obj) {
        return super.isContainer(obj);
    }

    public boolean isMap(Object obj) {
        return MutableValue.extractValueFromMutable(obj) instanceof Map;
    }

    public Object getProperty(Object obj, Object key) {
        Object oldValue = super.getProperty(MutableValue.extractValueFromMutable(obj), key);
        if (oldValue instanceof MutableValue && this.valueToWrite != null) {
            ((MutableValue)oldValue).setValue(this.valueToWrite);
            return this.valueToWrite;
        }
        return MutableValue.extractValueFromMutable(oldValue);
    }

    public void setProperty(Object obj, Object key, Object value) {
        super.setProperty(MutableValue.extractValueFromMutable(obj), key, value);
    }

    public Collection<String> getPropertyKeys(Object obj) {
        return super.getPropertyKeys(MutableValue.extractValueFromMutable(obj));
    }

    public int length(Object obj) {
        return super.length(MutableValue.extractValueFromMutable(obj));
    }

    public Iterable<Object> toIterable(Object obj) {
        return super.toIterable(MutableValue.extractValueFromMutable(obj));
    }

    private Object convertToPlainJavaImplementation(JSON jsonRoot) {
        if (jsonRoot.isArray()) {
            ArrayList<Object> returnedList = new ArrayList<Object>();
            JSONArray array = (JSONArray)jsonRoot;
            for (Object originalValue : array) {
                if (originalValue instanceof JSON) {
                    returnedList.add(this.convertToPlainJavaImplementation((JSON)originalValue));
                    continue;
                }
                returnedList.add(originalValue);
            }
            return returnedList;
        }
        if (jsonRoot instanceof JSONObject) {
            HashMap returnedMap = new HashMap();
            JSONObject jsonObject = (JSONObject)jsonRoot;
            for (Object o : jsonObject.keySet()) {
                Object value = jsonObject.get(o);
                if (value instanceof JSON) {
                    returnedMap.put(o, this.convertToPlainJavaImplementation((JSON)value));
                    continue;
                }
                returnedMap.put(o, value);
            }
            return returnedMap;
        }
        return null;
    }
}

