/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.log;

import com.eviware.soapui.model.security.SecurityScan;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.security.result.SecurityResult;
import com.eviware.soapui.security.result.SecurityScanRequestResult;
import com.eviware.soapui.security.result.SecurityScanResult;
import com.eviware.soapui.security.result.SecurityTestStepResult;
import com.eviware.soapui.security.scan.AbstractSecurityScan;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import org.apache.commons.collections.list.TreeList;

public class SecurityTestLogModel
extends AbstractListModel {
    private List<Object> items = Collections.synchronizedList(new TreeList());
    private List<SoftReference<SecurityResult>> results = Collections.synchronizedList(new TreeList());
    private int maxSize = 100;
    private int stepCount;
    private int checkCount;
    private int requestCount;
    private int currentCheckEntriesCount;
    private int currentStepEntriesCount;

    @Override
    public synchronized Object getElementAt(int arg0) {
        try {
            return this.items.get(arg0);
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public int getSize() {
        return this.items.size();
    }

    public synchronized void addText(String msg) {
        this.items.add(msg);
        this.results.add(null);
        this.fireIntervalAdded(this, this.items.size() - 1, this.items.size() - 1);
        this.enforceMaxSize();
    }

    public synchronized SecurityResult getTestStepResultAt(int index) {
        if (index >= this.results.size()) {
            return null;
        }
        SoftReference<SecurityResult> result = this.results.get(index);
        return result == null ? null : result.get();
    }

    public synchronized boolean addSecurityTestStepResult(TestStep testStep) {
        ++this.stepCount;
        this.checkCount = 0;
        this.currentStepEntriesCount = 1;
        int size = this.items.size();
        if (AbstractSecurityScan.isSecurable(testStep)) {
            SecurityTestStepResult result = new SecurityTestStepResult(testStep, null);
            SoftReference<SecurityTestStepResult> stepResultRef = new SoftReference<SecurityTestStepResult>(result);
            this.items.add("Step " + this.stepCount + " [" + result.getTestStep().getName() + "] ");
            this.results.add(stepResultRef);
            this.fireIntervalAdded(this, size, this.items.size() - 1);
            this.enforceMaxSize();
            return true;
        }
        return false;
    }

    public synchronized void updateSecurityTestStepResult(SecurityTestStepResult result, boolean errorsOnly, boolean hasChecksToProcess, boolean startStepLogEntryAdded) {
        int startStepIndex = 0;
        if (this.items.size() > this.currentStepEntriesCount) {
            startStepIndex = this.currentStepEntriesCount > 0 ? this.items.size() - this.currentStepEntriesCount : this.items.size();
        }
        if (errorsOnly && !result.isHasScansWithWarnings() || startStepLogEntryAdded && !hasChecksToProcess) {
            int size;
            for (size = this.items.size() - 1; size >= startStepIndex; --size) {
                this.items.remove(size);
                this.results.remove(size);
            }
            if (startStepIndex > 0 && size > 0) {
                this.fireIntervalRemoved(this, startStepIndex, size);
            } else {
                this.fireIntervalRemoved(this, 0, size);
            }
        } else if (startStepLogEntryAdded) {
            try {
                if (startStepIndex > 0 && startStepIndex < this.maxSize) {
                    String statusToDisplay = this.getStatusToDisplay(result.getExecutionProgressStatus());
                    this.items.set(startStepIndex, "Step " + this.stepCount + " [" + result.getTestStep().getName() + "] " + statusToDisplay + ": took " + result.getTimeTaken() + " ms");
                    SoftReference<SecurityTestStepResult> stepResultRef = new SoftReference<SecurityTestStepResult>(result);
                    this.results.set(startStepIndex, stepResultRef);
                    this.fireContentsChanged(this, startStepIndex, startStepIndex);
                }
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        this.currentStepEntriesCount = 0;
    }

    private String getStatusToDisplay(SecurityResult.ResultStatus result) {
        String statusToDisplay = "";
        switch (result) {
            case FAILED: {
                statusToDisplay = "Alerts";
                break;
            }
            case OK: {
                statusToDisplay = "No Alerts";
                break;
            }
            case SKIPPED: {
                statusToDisplay = "Skipped";
                break;
            }
            case MISSING_ASSERTIONS: {
                statusToDisplay = "Missing Assertions";
                break;
            }
            case MISSING_PARAMETERS: {
                statusToDisplay = "Missing Parameters";
            }
        }
        return statusToDisplay;
    }

    public synchronized void addSecurityScanResult(SecurityScan securityCheck) {
        int size = this.items.size();
        ++this.checkCount;
        this.requestCount = 0;
        SecurityScanResult securityCheckResult = securityCheck.getSecurityScanResult();
        SoftReference<SecurityScanResult> checkResultRef = new SoftReference<SecurityScanResult>(securityCheckResult);
        this.items.add("SecurityScan " + this.checkCount + " [" + securityCheck.getName() + "] ");
        this.results.add(checkResultRef);
        this.currentCheckEntriesCount = 1;
        ++this.currentStepEntriesCount;
        this.fireIntervalAdded(this, size, this.items.size() - 1);
        this.enforceMaxSize();
    }

    public synchronized void updateSecurityScanResult(SecurityScanResult securityCheckResult, boolean errorsOnly) {
        int startCheckIndex = 0;
        if (this.items.size() > this.currentCheckEntriesCount) {
            startCheckIndex = this.currentCheckEntriesCount > 0 ? this.items.size() - this.currentCheckEntriesCount : this.items.size();
        }
        if (errorsOnly && !securityCheckResult.isHasRequestsWithWarnings()) {
            int size;
            --this.checkCount;
            for (size = this.items.size() - 1; size >= startCheckIndex; --size) {
                this.items.remove(size);
                this.results.remove(size);
            }
            if (startCheckIndex > 0) {
                this.fireIntervalRemoved(this, startCheckIndex, size);
            } else {
                this.fireIntervalRemoved(this, startCheckIndex, size);
            }
        } else {
            SecurityScan securityCheck = securityCheckResult.getSecurityScan();
            securityCheckResult.detectMissingItems();
            StringBuilder outStr = new StringBuilder("SecurityScan ");
            String statusToDisplay = this.getStatusToDisplay(securityCheckResult.getExecutionProgressStatus());
            outStr.append(this.checkCount).append(" [").append(securityCheck.getName()).append("] ").append(statusToDisplay).append(", took = ").append(securityCheckResult.getTimeTaken());
            try {
                if (startCheckIndex > 0 && startCheckIndex < this.maxSize) {
                    this.items.set(startCheckIndex, outStr.toString());
                    SoftReference<SecurityScanResult> checkResultRef = new SoftReference<SecurityScanResult>(securityCheckResult);
                    this.results.set(startCheckIndex, checkResultRef);
                    this.currentCheckEntriesCount = 0;
                    this.fireContentsChanged(this, startCheckIndex, startCheckIndex);
                }
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
        }
    }

    public synchronized void addSecurityScanRequestResult(SecurityScanRequestResult securityCheckRequestResult) {
        int size = this.items.size();
        ++this.requestCount;
        SoftReference<SecurityScanRequestResult> checkReqResultRef = new SoftReference<SecurityScanRequestResult>(securityCheckRequestResult);
        this.items.add(securityCheckRequestResult.getChangedParamsInfo(this.requestCount));
        this.results.add(checkReqResultRef);
        ++this.currentCheckEntriesCount;
        ++this.currentStepEntriesCount;
        for (String msg : securityCheckRequestResult.getMessages()) {
            this.items.add(" -> " + msg);
            this.results.add(checkReqResultRef);
            ++this.currentCheckEntriesCount;
            ++this.currentStepEntriesCount;
        }
        this.fireIntervalAdded(this, size, this.items.size() - 1);
        this.enforceMaxSize();
    }

    public synchronized void clear() {
        int sz = this.items.size();
        this.items.clear();
        this.results.clear();
        this.stepCount = 0;
        this.fireIntervalRemoved(this, 0, sz);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        this.enforceMaxSize();
    }

    private synchronized void enforceMaxSize() {
        while (this.items.size() > this.maxSize) {
            this.items.remove(0);
            this.results.remove(0);
            this.fireIntervalRemoved(this, 0, 0);
        }
    }

    public synchronized int getIndexOfSecurityScan(SecurityScan check) {
        for (int i = 0; i < this.results.size(); ++i) {
            SecurityResult referent;
            SoftReference<SecurityResult> result = this.results.get(i);
            if (result == null || !((referent = result.get()) instanceof SecurityScanResult) || ((SecurityScanResult)referent).getSecurityScan() != check) continue;
            return i;
        }
        return -1;
    }
}

