/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.assertion;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.CrossSiteScriptingScanConfig;
import com.eviware.soapui.config.HttpRequestConfig;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.support.HttpUtils;
import com.eviware.soapui.impl.wsdl.panels.assertions.AssertionListEntry;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.AbstractGroovyEditorModel;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AbstractTestAssertionFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestStepRegistry;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.security.SecurityTestRunContext;
import com.eviware.soapui.security.SecurityTestRunner;
import com.eviware.soapui.security.SecurityTestRunnerImpl;
import com.eviware.soapui.security.scan.CrossSiteScriptingScan;
import com.eviware.soapui.support.SecurityScanUtil;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.GroovyEditorComponent;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.support.scripting.SoapUIScriptEngineRegistry;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JScrollPane;
import org.apache.xmlbeans.XmlObject;

public class CrossSiteScriptAssertion
extends WsdlMessageAssertion
implements ResponseAssertion {
    public static final String ID = "CrosSiteScript";
    public static final String LABEL = "Cross Site Scripting Detection";
    public static final String DESCRIPTION = "Cross Site Scripting....assertion for...";
    public static final String GROOVY_SCRIPT = "groovyScript";
    public static final String CHECK_RESPONSE = "checkResponse";
    public static final String CHECK_SEPARATE_HTML = "checkSeparateHTML";
    private XFormDialog dialog;
    private String script;
    private GroovyEditorModel groovyEditorModel = new GroovyEditorModel(this);
    private SoapUIScriptEngine scriptEngine;
    MessageExchange messageExchange;
    SubmitContext context;
    private boolean checkResponse;
    private boolean checkSeparateHTML;

    public CrossSiteScriptAssertion(TestAssertionConfig assertionConfig, Assertable assertable) {
        super(assertionConfig, assertable, false, true, false, true);
        this.init();
        this.scriptEngine = SoapUIScriptEngineRegistry.create(this);
    }

    private void init() {
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(this.getConfiguration());
        this.script = reader.readString(GROOVY_SCRIPT, "");
        this.checkResponse = reader.readBoolean(CHECK_RESPONSE, true);
        this.checkSeparateHTML = reader.readBoolean(CHECK_SEPARATE_HTML, false);
        this.groovyEditorModel.setScript(this.script);
    }

    @Override
    protected String internalAssertResponse(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        TestStep testStep = (TestStep)context.getProperty("testStep");
        testStep = SecurityTestRunnerImpl.cloneTestStepForSecurityScan((WsdlTestStep)testStep);
        SecurityTestRunner securityTestRunner = (SecurityTestRunner)context.getProperty("testCaseRunner");
        List<String> urls = this.submitScript(messageExchange, context);
        CrossSiteScriptingScanConfig parameterExposureCheckConfig = (CrossSiteScriptingScanConfig)context.getProperty("CrossSiteScriptingScanConfig");
        ArrayList<AssertionError> assertionErrorList = new ArrayList<AssertionError>();
        boolean throwExceptionCheckResponse = false;
        if (this.checkResponse) {
            throwExceptionCheckResponse = this.checkResponse(messageExchange, context, parameterExposureCheckConfig, assertionErrorList);
        }
        boolean throwExceptionCheckSeparateHTML = false;
        if (this.checkSeparateHTML) {
            throwExceptionCheckSeparateHTML = this.checkSeparateHTML(messageExchange, context, testStep, securityTestRunner, urls, parameterExposureCheckConfig, assertionErrorList);
        }
        if (throwExceptionCheckResponse || throwExceptionCheckSeparateHTML) {
            throw new AssertionException(assertionErrorList.toArray(new AssertionError[assertionErrorList.size()]));
        }
        return "OK";
    }

    private boolean checkSeparateHTML(MessageExchange messageExchange, SubmitContext context, TestStep testStep, SecurityTestRunner securityTestRunner, List<String> urls, CrossSiteScriptingScanConfig parameterExposureCheckConfig, List<AssertionError> assertionErrorList) {
        boolean throwException = false;
        for (String url : urls) {
            HttpTestRequestStep httpRequest = this.createHttpRequest((WsdlTestStep)testStep, url);
            MessageExchange messageExchange2 = (MessageExchange)((Object)httpRequest.run((TestCaseRunner)((Object)securityTestRunner), (SecurityTestRunContext)context));
            for (String value : parameterExposureCheckConfig.getParameterExposureStringsList()) {
                value = context.expand(value);
                String match = SecurityScanUtil.contains(context, new String(messageExchange2.getRawResponseData()), value, false);
                if (match == null) continue;
                String shortValue = value.length() > 25 ? value.substring(0, 22) + "... " : value;
                String message = "XSS content sent in request '" + shortValue + "' is exposed in response on link " + url + " . Possibility for XSS script attack in: " + messageExchange.getModelItem().getName();
                assertionErrorList.add(new AssertionError(message));
                throwException = true;
            }
        }
        return throwException;
    }

    private boolean checkResponse(MessageExchange messageExchange, SubmitContext context, CrossSiteScriptingScanConfig parameterExposureCheckConfig, List<AssertionError> assertionErrorList) {
        boolean throwException = false;
        for (String value : parameterExposureCheckConfig.getParameterExposureStringsList()) {
            value = context.expand(value);
            String match = SecurityScanUtil.contains(context, new String(messageExchange.getRawResponseData()), value, false);
            if (match == null) continue;
            String shortValue = value.length() > 25 ? value.substring(0, 22) + "... " : value;
            String message = "Content that is sent in request '" + shortValue + "' is exposed in response. Possibility for XSS script attack in: " + messageExchange.getModelItem().getName();
            assertionErrorList.add(new AssertionError(message));
            throwException = true;
        }
        return throwException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> submitScript(MessageExchange messageExchange, SubmitContext context) {
        ArrayList<String> urls = new ArrayList();
        this.scriptEngine.setScript(this.script);
        this.scriptEngine.setVariable("urls", urls);
        this.scriptEngine.setVariable("messageExchange", messageExchange);
        this.messageExchange = messageExchange;
        this.scriptEngine.setVariable("context", context);
        this.context = context;
        this.scriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
        try {
            Object result = this.scriptEngine.run();
            if (result instanceof List) {
                urls = (List)result;
            }
        }
        catch (Exception ex) {
            SoapUI.logError(ex);
        }
        finally {
            this.scriptEngine.clearVariables();
        }
        return urls;
    }

    private HttpTestRequestStep createHttpRequest(WsdlTestStep testStep2, String url) {
        HttpRequestConfig httpRequest = HttpRequestConfig.Factory.newInstance();
        httpRequest.setEndpoint(HttpUtils.completeUrlWithHttpIfProtocolIsNotHttpOrHttpsOrPropertyExpansion(url));
        httpRequest.setMethod("GET");
        TestStepConfig testStepConfig = TestStepConfig.Factory.newInstance();
        testStepConfig.setType("httprequest");
        testStepConfig.setConfig(httpRequest);
        testStepConfig.setName("Separate Request");
        WsdlTestStepFactory factory = WsdlTestStepRegistry.getInstance().getFactory("httprequest");
        return (HttpTestRequestStep)factory.buildTestStep(testStep2.getTestCase(), testStepConfig, false);
    }

    @Override
    protected String internalAssertProperty(TestPropertyHolder source, String propertyName, MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return null;
    }

    @Override
    protected String internalAssertRequest(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return null;
    }

    protected XmlObject createConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add(GROOVY_SCRIPT, this.script);
        builder.add(CHECK_RESPONSE, this.checkResponse);
        builder.add(CHECK_SEPARATE_HTML, this.checkSeparateHTML);
        return builder.finish();
    }

    @Override
    public boolean configure() {
        if (this.dialog == null) {
            this.buildDialog();
        }
        this.dialog.show();
        if (this.dialog.getReturnValue() == 1) {
            this.checkResponse = Boolean.valueOf(this.dialog.getFormField("###Check Response").getValue());
            this.checkSeparateHTML = Boolean.valueOf(this.dialog.getFormField("###Check Separate HTML").getValue());
            this.setConfiguration(this.createConfiguration());
        }
        return true;
    }

    protected GroovyEditorComponent buildGroovyPanel() {
        return new GroovyEditorComponent(this.groovyEditorModel, null);
    }

    protected void buildDialog() {
        this.dialog = ADialogBuilder.buildDialog(CrossSiteScripSeparateHTMLConfigDialog.class);
        this.dialog.setSize(600, 600);
        this.dialog.setBooleanValue("###Check Response", this.checkResponse);
        this.dialog.setBooleanValue("###Check Separate HTML", this.checkSeparateHTML);
        final GroovyEditorComponent groovyEditorComponent = this.buildGroovyPanel();
        this.dialog.getFormField("###Groovy url list").setProperty("component", new JScrollPane(groovyEditorComponent));
        this.dialog.getFormField("###Groovy url list").setProperty("dimension", new Dimension(450, 400));
        this.dialog.getFormField("###Check Separate HTML").addFormFieldListener(new XFormFieldListener(){

            @Override
            public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                groovyEditorComponent.setEnabled(new Boolean(newValue));
            }
        });
        groovyEditorComponent.setEnabled(this.checkSeparateHTML);
    }

    @Override
    public void release() {
        if (this.dialog != null) {
            this.dialog.release();
        }
        super.release();
    }

    @AForm(description="", name="Cross Site Scripting on Separate HTML", helpUrl="http://www.soapui.org/Security/cross-site-scripting.html")
    protected static interface CrossSiteScripSeparateHTMLConfigDialog {
        @AField(description="Check Imediate Response", name="###Check Response", type=AField.AFieldType.BOOLEAN)
        public static final String CHECK_RESPONSE = "###Check Response";
        @AField(description="Check Response from URLs specified in Custom Script", name="###Check Separate HTML", type=AField.AFieldType.BOOLEAN)
        public static final String CHECK_SEPARATE_HTML = "###Check Separate HTML";
        @AField(description="", name="Enter Custom Script that returns a list of URLs to check for Cross Site Scripts ", type=AField.AFieldType.LABEL)
        public static final String LABEL = "Enter Custom Script that returns a list of URLs to check for Cross Site Scripts ";
        @AField(description="Groovy script", name="###Groovy url list", type=AField.AFieldType.COMPONENT)
        public static final String GROOVY = "###Groovy url list";
    }

    private class GroovyEditorModel
    extends AbstractGroovyEditorModel {
        @Override
        public Action createRunAction() {
            return new AbstractAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    Object result = null;
                    List urls = new ArrayList();
                    CrossSiteScriptAssertion.this.scriptEngine.setScript(CrossSiteScriptAssertion.this.script);
                    CrossSiteScriptAssertion.this.scriptEngine.setVariable("urls", urls);
                    CrossSiteScriptAssertion.this.scriptEngine.setVariable("messageExchange", CrossSiteScriptAssertion.this.messageExchange);
                    CrossSiteScriptAssertion.this.scriptEngine.setVariable("context", CrossSiteScriptAssertion.this.context);
                    CrossSiteScriptAssertion.this.scriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
                    try {
                        result = CrossSiteScriptAssertion.this.scriptEngine.run();
                        if (result instanceof List) {
                            urls = (List)result;
                        }
                        String generatedUrls = "";
                        for (String url : urls) {
                            generatedUrls = generatedUrls + "\n" + url;
                        }
                        UISupport.showInfoMessage("Generated urls :" + generatedUrls + " \n\nScript result" + (result == null ? "" : ": " + result + ""));
                    }
                    catch (Exception ex) {
                        SoapUI.logError(ex);
                    }
                    finally {
                        CrossSiteScriptAssertion.this.scriptEngine.clearVariables();
                    }
                }
            };
        }

        public GroovyEditorModel(ModelItem modelItem) {
            super(new String[]{"urls", "log", "context", "messageExchange"}, modelItem, "");
        }

        @Override
        public String getScript() {
            return CrossSiteScriptAssertion.this.script;
        }

        @Override
        public void setScript(String text) {
            CrossSiteScriptAssertion.this.script = text;
        }
    }

    public static class Factory
    extends AbstractTestAssertionFactory {
        public Factory() {
            super(CrossSiteScriptAssertion.ID, CrossSiteScriptAssertion.LABEL, CrossSiteScriptAssertion.class, CrossSiteScriptingScan.class);
        }

        @Override
        public String getCategory() {
            return "";
        }

        @Override
        public Class<? extends WsdlMessageAssertion> getAssertionClassType() {
            return CrossSiteScriptAssertion.class;
        }

        @Override
        public AssertionListEntry getAssertionListEntry() {
            return new AssertionListEntry(CrossSiteScriptAssertion.ID, CrossSiteScriptAssertion.LABEL, CrossSiteScriptAssertion.DESCRIPTION);
        }
    }
}

