/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.tree.nodes.support;

import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestSuiteListener;
import com.eviware.soapui.model.tree.nodes.support.EmptyModelItem;
import com.eviware.soapui.support.UISupport;

public class WsdlTestStepsModelItem
extends EmptyModelItem {
    private TestCase testCase;
    private TestSuiteListener listener = new InternalTestSuiteListener();

    public WsdlTestStepsModelItem(TestCase testCase) {
        super(WsdlTestStepsModelItem.createLabel(testCase), UISupport.createImageIcon("/teststeps.gif"));
        this.testCase = testCase;
        testCase.getTestSuite().addTestSuiteListener(this.listener);
    }

    private static String createLabel(TestCase testCase) {
        return "Test Steps (" + testCase.getTestStepCount() + ")";
    }

    @Override
    public Settings getSettings() {
        return this.testCase.getSettings();
    }

    @Override
    public String getName() {
        return WsdlTestStepsModelItem.createLabel(this.testCase);
    }

    public WsdlTestCase getTestCase() {
        return (WsdlTestCase)this.testCase;
    }

    @Override
    public void release() {
        super.release();
        this.testCase.getTestSuite().removeTestSuiteListener(this.listener);
    }

    public void updateLabel() {
        this.setName(WsdlTestStepsModelItem.createLabel(this.testCase));
    }

    public class InternalTestSuiteListener
    extends TestSuiteListenerAdapter
    implements TestSuiteListener {
        @Override
        public void testStepAdded(TestStep testStep, int index) {
            if (testStep.getTestCase() == WsdlTestStepsModelItem.this.testCase) {
                WsdlTestStepsModelItem.this.updateLabel();
            }
        }

        @Override
        public void testStepRemoved(TestStep testStep, int index) {
            if (testStep.getTestCase() == WsdlTestStepsModelItem.this.testCase) {
                WsdlTestStepsModelItem.this.updateLabel();
            }
        }

        @Override
        public void testCaseRemoved(TestCase testCase) {
            if (testCase == WsdlTestStepsModelItem.this.testCase) {
                testCase.getTestSuite().removeTestSuiteListener(WsdlTestStepsModelItem.this.listener);
            }
        }
    }
}

