/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.support;

import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestSuite;

public class ProjectMetrics {
    private final Project project;

    public ProjectMetrics(Project project) {
        this.project = project;
    }

    public int getTestCaseCount() {
        int result = 0;
        for (TestSuite testSuite : this.project.getTestSuiteList()) {
            result += testSuite.getTestCaseCount();
        }
        return result;
    }

    public int getTestStepCount() {
        int result = 0;
        for (TestSuite testSuite : this.project.getTestSuiteList()) {
            for (TestCase testCase : testSuite.getTestCaseList()) {
                result += testCase.getTestStepCount();
            }
        }
        return result;
    }

    public int getAssertionCount() {
        int result = 0;
        for (TestSuite testSuite : this.project.getTestSuiteList()) {
            for (TestCase testCase : testSuite.getTestCaseList()) {
                for (TestStep testStep : testCase.getTestStepList()) {
                    if (!(testStep instanceof Assertable)) continue;
                    result += ((Assertable)((Object)testStep)).getAssertionCount();
                }
            }
        }
        return result;
    }

    public int getLoadTestCount() {
        int result = 0;
        for (TestSuite testSuite : this.project.getTestSuiteList()) {
            for (TestCase testCase : testSuite.getTestCaseList()) {
                result += testCase.getLoadTestCount();
            }
        }
        return result;
    }

    public int getMockOperationCount() {
        int result = 0;
        for (MockService mockService : this.project.getMockServiceList()) {
            result += mockService.getMockOperationCount();
        }
        return result;
    }

    public int getMockResponseCount() {
        int result = 0;
        for (MockService mockService : this.project.getMockServiceList()) {
            for (MockOperation mockOperation : mockService.getMockOperationList()) {
                result += mockOperation.getMockResponseCount();
            }
        }
        return result;
    }

    public int getRestMockActionCount() {
        int restMockActionCount = 0;
        for (MockService mockService : this.project.getRestMockServiceList()) {
            restMockActionCount += mockService.getMockOperationCount();
        }
        return restMockActionCount;
    }

    public int getRestMockResponseCount() {
        int restMockResponseCount = 0;
        for (MockService mockService : this.project.getRestMockServiceList()) {
            for (MockOperation mockOperation : mockService.getMockOperationList()) {
                restMockResponseCount += mockOperation.getMockResponseCount();
            }
        }
        return restMockResponseCount;
    }
}

