/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.basic;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.wsdl.panels.assertions.AssertionListEntry;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertedXPathImpl;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertedXPathsContainer;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AbstractTestAssertionFactory;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.basic.AssertionConfigurationDialog;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.support.XPathReference;
import com.eviware.soapui.model.support.XPathReferenceContainer;
import com.eviware.soapui.model.support.XPathReferenceImpl;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.RequestAssertion;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.types.StringList;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.eviware.soapui.support.xml.XmlUtils;
import java.util.ArrayList;
import javax.swing.JTextArea;
import junit.framework.ComparisonFailure;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlQName;
import org.apache.xmlbeans.impl.values.XmlValueDisconnectedException;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceEngine;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.XMLAssert;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XPathContainsAssertion
extends WsdlMessageAssertion
implements RequestAssertion,
ResponseAssertion,
XPathReferenceContainer {
    private String expectedContent;
    private String path;
    private boolean allowWildcards;
    private boolean ignoreNamespaceDifferences;
    private boolean ignoreComments;
    public static final String ID = "XPath Match";
    public static final String LABEL = "XPath Match";
    public static final String DESCRIPTION = "Uses an XPath expression to select content from the target property and compares the result to an expected value. Applicable to any property containing XML.";
    protected AssertionConfigurationDialog configurationDialog;

    public XPathContainsAssertion(TestAssertionConfig assertionConfig, Assertable assertable) {
        super(assertionConfig, assertable, true, true, true, true);
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(this.getConfiguration());
        this.path = reader.readString("path", null);
        this.expectedContent = reader.readString("content", null);
        this.allowWildcards = reader.readBoolean("allowWildcards", false);
        this.ignoreNamespaceDifferences = reader.readBoolean("ignoreNamspaceDifferences", false);
        this.ignoreComments = reader.readBoolean("ignoreComments", false);
    }

    public String getExpectedContent() {
        return this.expectedContent;
    }

    public void setExpectedContent(String expectedContent) {
        this.setExpectedContent(expectedContent, true);
    }

    @Deprecated
    public void setContent(String content) {
        this.setExpectedContent(content);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
        this.setConfiguration(this.createConfiguration());
    }

    public boolean isAllowWildcards() {
        return this.allowWildcards;
    }

    public void setAllowWildcards(boolean allowWildcards) {
        this.allowWildcards = allowWildcards;
        this.setConfiguration(this.createConfiguration());
    }

    public boolean isIgnoreNamespaceDifferences() {
        return this.ignoreNamespaceDifferences;
    }

    public void setIgnoreNamespaceDifferences(boolean ignoreNamespaceDifferences) {
        this.ignoreNamespaceDifferences = ignoreNamespaceDifferences;
        this.setConfiguration(this.createConfiguration());
    }

    public boolean isIgnoreComments() {
        return this.ignoreComments;
    }

    public void setIgnoreComments(boolean ignoreComments) {
        this.ignoreComments = ignoreComments;
        this.setConfiguration(this.createConfiguration());
    }

    @Override
    protected String internalAssertResponse(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        if (!messageExchange.hasResponse()) {
            return "Missing Response";
        }
        return this.assertContent(messageExchange.getResponseContentAsXml(), context, "Response");
    }

    @Override
    protected String internalAssertProperty(TestPropertyHolder source, String propertyName, MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        if (!XmlUtils.seemsToBeXml(source.getPropertyValue(propertyName))) {
            throw new AssertionException(new AssertionError("Property '" + propertyName + "' has value which is not xml!"));
        }
        return this.assertContent(source.getPropertyValue(propertyName), context, propertyName);
    }

    public String assertContent(String response, SubmitContext context, String type) throws AssertionException {
        try {
            if (this.path == null) {
                return "Missing path for XPath assertion";
            }
            if (this.expectedContent == null) {
                return "Missing content for XPath assertion";
            }
            XmlOptions options = new XmlOptions();
            if (this.ignoreComments) {
                options.setLoadStripComments();
            }
            XmlObject xml = XmlUtils.createXmlObject(response, options);
            String expandedPath = PropertyExpander.expandProperties(context, this.path);
            XmlObject[] items = xml.selectPath(expandedPath);
            AssertedXPathsContainer assertedXPathsContainer = (AssertedXPathsContainer)context.getProperty(AssertedXPathsContainer.ASSERTEDXPATHSCONTAINER_PROPERTY);
            XmlObject contentObj = null;
            String expandedContent = PropertyExpander.expandProperties(context, this.expectedContent);
            if (!expandedPath.endsWith("text()")) {
                try {
                    contentObj = XmlUtils.createXmlObject(expandedContent, options);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (items.length == 0) {
                throw new Exception("Missing content for xpath [" + this.path + "] in " + type);
            }
            options.setSavePrettyPrint();
            options.setSaveOuter();
            for (int c = 0; c < items.length; ++c) {
                try {
                    String xpath;
                    AssertedXPathImpl assertedXPathImpl = null;
                    if (assertedXPathsContainer != null && (xpath = XmlUtils.createAbsoluteXPath(items[c].getDomNode())) != null) {
                        XmlObject xmlObj = items[c];
                        assertedXPathImpl = new AssertedXPathImpl(this, xpath, xmlObj);
                        assertedXPathsContainer.addAssertedXPath(assertedXPathImpl);
                    }
                    if (contentObj == null) {
                        String expandedValue;
                        if (items[c] instanceof XmlAnySimpleType && !(items[c] instanceof XmlQName)) {
                            String value = ((XmlAnySimpleType)items[c]).getStringValue();
                            expandedValue = PropertyExpander.expandProperties(context, value);
                            XMLAssert.assertEquals((String)expandedContent, (String)expandedValue);
                        } else {
                            Node domNode = items[c].getDomNode();
                            switch (domNode.getNodeType()) {
                                case 1: {
                                    expandedValue = PropertyExpander.expandProperties(context, XmlUtils.getElementText((Element)domNode));
                                    if (this.allowWildcards) {
                                        Tools.assertSimilar(expandedContent, expandedValue, '*');
                                        break;
                                    }
                                    XMLAssert.assertEquals((String)expandedContent, (String)expandedValue);
                                    break;
                                }
                                case 2: {
                                    expandedValue = PropertyExpander.expandProperties(context, domNode.getNodeValue());
                                    if (this.allowWildcards) {
                                        Tools.assertSimilar(expandedContent, expandedValue, '*');
                                        break;
                                    }
                                    XMLAssert.assertEquals((String)expandedContent, (String)expandedValue);
                                    break;
                                }
                                default: {
                                    expandedValue = PropertyExpander.expandProperties(context, domNode.getNodeValue());
                                    XMLAssert.assertEquals((String)expandedContent, (String)expandedValue);
                                    break;
                                }
                            }
                        }
                    } else {
                        this.compareValues(contentObj.xmlText(options), items[c].xmlText(options), items[c]);
                    }
                    break;
                }
                catch (Throwable e) {
                    if (c != items.length - 1) continue;
                    throw e;
                }
            }
        }
        catch (Throwable e) {
            String msg = "";
            if (e instanceof ComparisonFailure) {
                ComparisonFailure cf = (ComparisonFailure)e;
                String expected = cf.getExpected();
                String actual = cf.getActual();
                msg = "XPathContains comparison failed for path [" + this.path + "], expecting [" + expected + "], actual was [" + actual + "]";
            } else {
                msg = "XPathContains assertion failed for path [" + this.path + "] : " + e.getClass().getSimpleName() + ":" + e.getMessage();
            }
            throw new AssertionException(new AssertionError(msg));
        }
        return type + " matches content for [" + this.path + "]";
    }

    private void compareValues(String expandedContent, String expandedValue, XmlObject object) throws Exception {
        Diff diff = new Diff(expandedContent, expandedValue);
        InternalDifferenceListener internalDifferenceListener = new InternalDifferenceListener();
        diff.overrideDifferenceListener((DifferenceListener)internalDifferenceListener);
        if (!diff.identical()) {
            throw new Exception(diff.toString());
        }
        StringList nodesToRemove = internalDifferenceListener.getNodesToRemove();
        if (!nodesToRemove.isEmpty()) {
            for (String node : nodesToRemove) {
                XmlObject[] paths;
                if (node == null) continue;
                int ix = node.indexOf("\n/");
                if (ix != -1) {
                    node = node.substring(0, ix + 1) + "./" + node.substring(ix + 1);
                } else if (node.startsWith("/")) {
                    node = "/" + node;
                }
                if ((paths = object.selectPath(node)).length <= 0) continue;
                Node domNode = paths[0].getDomNode();
                if (domNode.getNodeType() == 2) {
                    ((Attr)domNode).getOwnerElement().removeAttributeNode((Attr)domNode);
                } else {
                    domNode.getParentNode().removeChild(domNode);
                }
                try {
                    object.set(object.copy());
                }
                catch (XmlValueDisconnectedException e) {
                    return;
                }
            }
        }
    }

    protected void addPathEditorActions(JXToolBar toolbar) {
        this.configurationDialog.addDeclareNamespaceButton(toolbar);
    }

    protected JTextArea getPathArea() {
        return this.configurationDialog == null ? null : this.configurationDialog.getPathArea();
    }

    protected JTextArea getContentArea() {
        return this.configurationDialog == null ? null : this.configurationDialog.getContentArea();
    }

    protected void addMatchEditorActions(JXToolBar toolbar) {
        this.configurationDialog.addMatchEditorActions(toolbar);
    }

    @Override
    public boolean configure() {
        if (this.configurationDialog == null) {
            this.configurationDialog = new AssertionConfigurationDialog(this.getAssertion());
        }
        return this.configurationDialog.configure();
    }

    protected XPathContainsAssertion getAssertion() {
        return this;
    }

    public XmlObject createConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        this.addConfigurationValues(builder);
        return builder.finish();
    }

    protected void addConfigurationValues(XmlObjectConfigurationBuilder builder) {
        builder.add("path", this.path);
        builder.add("content", this.expectedContent);
        builder.add("allowWildcards", this.allowWildcards);
        builder.add("ignoreNamspaceDifferences", this.ignoreNamespaceDifferences);
        builder.add("ignoreComments", this.ignoreComments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectFromCurrent() {
        XmlCursor cursor = null;
        try {
            String txt;
            String assertableContent = this.getAssertable().getAssertableContentAsXml();
            if (assertableContent == null || assertableContent.trim().length() == 0) {
                UISupport.showErrorMessage("Missing content to select from");
                return;
            }
            JTextArea pathArea = this.getPathArea();
            String string = txt = pathArea == null || !pathArea.isVisible() ? this.getPath() : pathArea.getSelectedText();
            if (txt == null) {
                txt = pathArea == null ? "" : pathArea.getText();
            }
            WsdlTestRunContext context = new WsdlTestRunContext(this.getAssertable().getTestStep());
            String expandedPath = PropertyExpander.expandProperties(context, txt.trim());
            JTextArea contentArea = this.getContentArea();
            if (contentArea != null && contentArea.isVisible()) {
                contentArea.setText("");
            }
            XmlObject xml = XmlUtils.createXmlObject(assertableContent);
            cursor = xml.newCursor();
            cursor.selectPath(expandedPath);
            if (!cursor.toNextSelection()) {
                UISupport.showErrorMessage("No match in current response");
            } else if (cursor.hasNextSelection()) {
                UISupport.showErrorMessage("More than one match in current response");
            } else {
                String stringValue = XmlUtils.getValueForMatch(cursor);
                if (contentArea != null && contentArea.isVisible()) {
                    contentArea.setText(stringValue);
                } else {
                    this.setExpectedContent(stringValue, false);
                }
            }
        }
        catch (Throwable e) {
            UISupport.showErrorMessage("Invalid XPath expression.");
            SoapUI.logError(e);
        }
        finally {
            if (cursor != null) {
                cursor.dispose();
            }
        }
    }

    protected void setExpectedContent(String expectedContent, boolean save) {
        this.expectedContent = expectedContent;
        if (save) {
            this.setConfiguration(this.createConfiguration());
        }
    }

    public String getPathAreaTitle() {
        return "Specify xpath expression and expected result";
    }

    public String getPathAreaDescription() {
        return "declare namespaces with <code>declare namespace &lt;prefix&gt;='&lt;namespace&gt;';</code>";
    }

    public String getPathAreaToolTipText() {
        return "Specifies the XPath expression to select from the message for validation";
    }

    public String getPathAreaBorderTitle() {
        return "XPath Expression";
    }

    public String getContentAreaToolTipText() {
        return "Specifies the expected result of the XPath expression";
    }

    public String getContentAreaBorderTitle() {
        return "Expected Result";
    }

    public boolean canAssertXmlContent() {
        return true;
    }

    public String getConfigurationDialogTitle() {
        return "XPath Match Configuration";
    }

    @Override
    protected String internalAssertRequest(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        if (!messageExchange.hasRequest(true)) {
            return "Missing Request";
        }
        return this.assertContent(messageExchange.getRequestContent(), context, "Request");
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        ArrayList<PropertyExpansion> result = new ArrayList<PropertyExpansion>();
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this.getAssertable().getModelItem(), this, "expectedContent"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this.getAssertable().getModelItem(), this, "path"));
        return result.toArray(new PropertyExpansion[result.size()]);
    }

    @Override
    public XPathReference[] getXPathReferences() {
        ArrayList<XPathReferenceImpl> result = new ArrayList<XPathReferenceImpl>();
        if (StringUtils.hasContent(this.getPath())) {
            TestStep testStep = this.getAssertable().getTestStep();
            TestProperty property = testStep instanceof WsdlTestRequestStep ? testStep.getProperty("Response") : testStep.getProperty("Request");
            result.add(new XPathReferenceImpl("XPath for " + this.getName() + " XPathContainsAssertion in " + testStep.getName(), property, this, "path"));
        }
        return result.toArray(new XPathReference[result.size()]);
    }

    public static class Factory
    extends AbstractTestAssertionFactory {
        public Factory() {
            super("XPath Match", "XPath Match", XPathContainsAssertion.class);
        }

        @Override
        public String getCategory() {
            return "Property Content";
        }

        @Override
        public Class<? extends WsdlMessageAssertion> getAssertionClassType() {
            return XPathContainsAssertion.class;
        }

        @Override
        public AssertionListEntry getAssertionListEntry() {
            return new AssertionListEntry("XPath Match", "XPath Match", XPathContainsAssertion.DESCRIPTION);
        }

        @Override
        public boolean canAssert(TestPropertyHolder modelItem, String property) {
            if (!modelItem.getProperty(property).getSchemaType().isPrimitiveType()) {
                return true;
            }
            String content = modelItem.getPropertyValue(property);
            return XmlUtils.seemsToBeXml(content);
        }
    }

    private final class InternalDifferenceListener
    implements DifferenceListener {
        private StringList nodesToRemove = new StringList();

        private InternalDifferenceListener() {
        }

        public int differenceFound(Difference diff) {
            if (XPathContainsAssertion.this.allowWildcards && (diff.getId() == DifferenceEngine.TEXT_VALUE.getId() || diff.getId() == DifferenceEngine.ATTR_VALUE.getId())) {
                if (Tools.isSimilar(diff.getControlNodeDetail().getValue(), diff.getTestNodeDetail().getValue(), '*')) {
                    this.addToNodesToRemove(diff);
                    return 1;
                }
            } else if (XPathContainsAssertion.this.allowWildcards && diff.getId() == DifferenceEngine.NODE_TYPE.getId()) {
                if (Tools.isSimilar(diff.getControlNodeDetail().getNode().getNodeValue(), diff.getTestNodeDetail().getNode().getNodeValue(), '*')) {
                    this.addToNodesToRemove(diff);
                    return 1;
                }
            } else if (XPathContainsAssertion.this.ignoreNamespaceDifferences && diff.getId() == 15) {
                return 1;
            }
            return 0;
        }

        private void addToNodesToRemove(Difference diff) {
            Node node = diff.getTestNodeDetail().getNode();
            String xp = XmlUtils.createAbsoluteXPath(node.getNodeType() == 2 ? node : node.getParentNode());
            this.nodesToRemove.add(xp);
        }

        public void skippedComparison(Node arg0, Node arg1) {
        }

        public StringList getNodesToRemove() {
            return this.nodesToRemove;
        }
    }
}

