/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.actions;

import com.eviware.soapui.impl.wsdl.panels.assertions.AddAssertionPanel;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.TestAssertionRegistry;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;

public class AddAssertionAction
extends AbstractAction {
    private final Assertable assertable;
    private AddAssertionPanel addAssertionPanel;

    public AddAssertionAction(Assertable assertable) {
        super("Add Assertion");
        this.assertable = assertable;
        this.putValue("ShortDescription", "Adds an assertion to this item");
        this.putValue("SmallIcon", UISupport.createImageIcon("/addAssertion.gif"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String[] assertions = TestAssertionRegistry.getInstance().getAvailableAssertionNames(this.assertable);
        if (assertions == null || assertions.length == 0) {
            UISupport.showErrorMessage("No assertions available for this message");
            return;
        }
        this.addAssertionPanel = new AddAssertionPanel(this.assertable);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AddAssertionAction.this.addAssertionPanel.setVisible(true);
            }
        });
    }

    public void release() {
        if (this.addAssertionPanel != null) {
            this.addAssertionPanel.release();
        }
    }
}

