/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.DefaultActionList;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class WsdlTestStepResult
implements TestStepResult {
    private static final String[] EMPTY_MESSAGES = new String[0];
    private final WsdlTestStep testStep;
    private List<String> messages = new ArrayList<String>();
    private Throwable error;
    private TestStepResult.TestStepStatus status = TestStepResult.TestStepStatus.UNKNOWN;
    private long timeTaken;
    private long timeStamp;
    private long size;
    private DefaultActionList actionList;
    private long startTime;
    private boolean discarded;
    private String testStepName;
    private static DefaultActionList discardedActionList = new DefaultActionList(null);

    public WsdlTestStepResult(WsdlTestStep testStep) {
        this.testStep = testStep;
        this.testStepName = testStep.getName();
        this.timeStamp = System.currentTimeMillis();
    }

    @Override
    public TestStepResult.TestStepStatus getStatus() {
        return this.status;
    }

    public void setStatus(TestStepResult.TestStepStatus status) {
        this.status = status;
    }

    @Override
    public TestStep getTestStep() {
        try {
            if (this.testStep != null) {
                this.testStep.getName();
            }
            return this.testStep;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public ActionList getActions() {
        if (this.isDiscarded()) {
            return discardedActionList;
        }
        if (this.actionList == null) {
            this.actionList = new DefaultActionList(this.testStepName);
            this.actionList.setDefaultAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (WsdlTestStepResult.this.getMessages().length > 0) {
                        StringBuffer buf = new StringBuffer("<html><body>");
                        if (WsdlTestStepResult.this.getError() != null) {
                            buf.append(WsdlTestStepResult.this.getError().toString()).append("<br/>");
                        }
                        for (String s : WsdlTestStepResult.this.getMessages()) {
                            buf.append(s).append("<br/>");
                        }
                        UISupport.showExtendedInfo("TestStep Result", "Step [" + WsdlTestStepResult.this.testStepName + "] ran with status [" + (Object)((Object)WsdlTestStepResult.this.getStatus()) + "]", buf.toString(), null);
                    } else if (WsdlTestStepResult.this.getError() != null) {
                        UISupport.showExtendedInfo("TestStep Result", "Step [" + WsdlTestStepResult.this.testStepName + "] ran with status [" + (Object)((Object)WsdlTestStepResult.this.getStatus()) + "]", WsdlTestStepResult.this.getError().toString(), null);
                    } else {
                        UISupport.showInfoMessage("Step [" + WsdlTestStepResult.this.testStepName + "] ran with status [" + (Object)((Object)WsdlTestStepResult.this.getStatus()) + "]", "TestStep Result");
                    }
                }
            });
        }
        return this.actionList;
    }

    public void addAction(Action action, boolean isDefault) {
        if (this.isDiscarded()) {
            return;
        }
        if (this.actionList == null) {
            this.actionList = new DefaultActionList(this.testStepName);
        }
        this.actionList.addAction(action);
        if (isDefault) {
            this.actionList.setDefaultAction(action);
        }
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    @Override
    public String[] getMessages() {
        return this.messages == null ? EMPTY_MESSAGES : this.messages.toArray(new String[this.messages.size()]);
    }

    public void addMessage(String message) {
        if (this.messages != null) {
            this.messages.add(message);
        }
    }

    @Override
    public long getTimeTaken() {
        return this.timeTaken;
    }

    public void setTimeTaken(long timeTaken) {
        this.timeTaken = timeTaken;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setSize(long size) {
        this.size = size;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void writeTo(PrintWriter writer) {
        writer.println("Status: " + (Object)((Object)this.getStatus()));
        writer.println("Time Taken: " + this.getTimeTaken());
        writer.println("Size: " + this.getSize());
        writer.println("Timestamp: " + new Date(this.getTimeStamp()).toString());
        writer.println("TestStep: " + this.getTestStep().getName());
        if (this.error != null) {
            writer.println("Error:" + this.error.toString());
        }
        if (this.messages != null) {
            writer.println("\r\n----------------- Messages ------------------------------");
            for (String message : this.messages) {
                if (message == null) continue;
                writer.println(message);
            }
        }
        if (this.isDiscarded()) {
            writer.println("Result has been Discarded!");
        }
    }

    public void startTimer() {
        this.startTime = System.nanoTime();
    }

    public void stopTimer() {
        this.timeTaken = (System.nanoTime() - this.startTime) / 1000000L;
    }

    @Override
    public void discard() {
        this.discarded = true;
        this.messages = null;
        this.error = null;
        this.actionList = null;
    }

    @Override
    public boolean isDiscarded() {
        return this.discarded;
    }

    public void addMessages(String[] messages) {
        if (this.messages != null) {
            this.messages.addAll(Arrays.asList(messages));
        }
    }

    static {
        discardedActionList.setDefaultAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UISupport.showErrorMessage("Result has been discarded");
            }
        });
    }
}

