/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.AttachmentConfig;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.config.WsdlRequestConfig;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.JMSResponse;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertableConfig;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertionsSupport;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.TestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlResponseMessageExchange;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.TestAssertionRegistry;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionsListener;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.monitor.TestMonitor;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ResolveContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;

public class WsdlTestRequest
extends WsdlRequest
implements Assertable,
TestRequest {
    public static final String RESPONSE_PROPERTY = WsdlTestRequest.class.getName() + "@response";
    public static final String STATUS_PROPERTY = WsdlTestRequest.class.getName() + "@status";
    private static ImageIcon validRequestIcon;
    private static ImageIcon failedRequestIcon;
    private static ImageIcon disabledRequestIcon;
    private static ImageIcon unknownRequestIcon;
    private Assertable.AssertionStatus currentStatus;
    private final WsdlTestRequestStep testStep;
    private AssertionsSupport assertionsSupport;
    private WsdlResponseMessageExchange messageExchange;
    private final boolean forLoadTest;
    private PropertyChangeNotifier notifier;

    public WsdlTestRequest(WsdlOperation operation, WsdlRequestConfig callConfig, WsdlTestRequestStep testStep, boolean forLoadTest) {
        super(operation, callConfig, forLoadTest);
        this.forLoadTest = forLoadTest;
        this.setSettings(new XmlBeansSettingsImpl(this, testStep.getSettings(), callConfig.getSettings()));
        this.testStep = testStep;
        this.initAssertions();
        if (!forLoadTest) {
            this.initIcons();
        }
    }

    public WsdlTestCase getTestCase() {
        return this.testStep.getTestCase();
    }

    @Override
    public ModelItem getParent() {
        return this.getTestStep();
    }

    protected void initIcons() {
        if (validRequestIcon == null) {
            validRequestIcon = UISupport.createImageIcon("/valid_request.gif");
        }
        if (failedRequestIcon == null) {
            failedRequestIcon = UISupport.createImageIcon("/invalid_request.gif");
        }
        if (unknownRequestIcon == null) {
            unknownRequestIcon = UISupport.createImageIcon("/unknown_request.gif");
        }
        if (disabledRequestIcon == null) {
            disabledRequestIcon = UISupport.createImageIcon("/disabled_request.gif");
        }
    }

    @Override
    protected AbstractHttpRequest.RequestIconAnimator<?> initIconAnimator() {
        return new TestRequestIconAnimator(this);
    }

    private void initAssertions() {
        this.assertionsSupport = new AssertionsSupport(this.testStep, new AssertableConfig(){

            @Override
            public TestAssertionConfig addNewAssertion() {
                return ((WsdlRequestConfig)WsdlTestRequest.this.getConfig()).addNewAssertion();
            }

            @Override
            public List<TestAssertionConfig> getAssertionList() {
                return ((WsdlRequestConfig)WsdlTestRequest.this.getConfig()).getAssertionList();
            }

            @Override
            public void removeAssertion(int ix) {
                ((WsdlRequestConfig)WsdlTestRequest.this.getConfig()).removeAssertion(ix);
            }

            @Override
            public TestAssertionConfig insertAssertion(TestAssertionConfig source, int ix) {
                TestAssertionConfig conf = ((WsdlRequestConfig)WsdlTestRequest.this.getConfig()).insertNewAssertion(ix);
                conf.set(source);
                return conf;
            }
        });
    }

    @Override
    public int getAssertionCount() {
        return this.assertionsSupport.getAssertionCount();
    }

    @Override
    public WsdlMessageAssertion getAssertionAt(int c) {
        return this.assertionsSupport.getAssertionAt(c);
    }

    @Override
    public void setResponse(HttpResponse response, SubmitContext context) {
        super.setResponse(response, context);
        this.assertResponse(context);
    }

    public void assertResponse(SubmitContext context) {
        if (this.notifier == null) {
            this.notifier = new PropertyChangeNotifier();
        }
        if (this.getResponse() instanceof JMSResponse) {
            this.messageExchange = this.getResponse() == null ? null : new WsdlResponseMessageExchange(this){

                @Override
                public boolean hasResponse() {
                    String responseContent = this.getResponseContent();
                    return responseContent != null;
                }
            };
        } else {
            WsdlResponseMessageExchange wsdlResponseMessageExchange = this.messageExchange = this.getResponse() == null ? null : new WsdlResponseMessageExchange(this);
        }
        if (this.messageExchange != null) {
            for (WsdlMessageAssertion assertion : this.assertionsSupport.getAssertionList()) {
                assertion.assertResponse(this.messageExchange, context);
            }
        }
        this.notifier.notifyChange();
    }

    @Override
    public WsdlMessageAssertion addAssertion(String assertionLabel) {
        PropertyChangeNotifier notifier = new PropertyChangeNotifier();
        try {
            WsdlMessageAssertion assertion = this.assertionsSupport.addWsdlAssertion(assertionLabel);
            if (assertion == null) {
                return null;
            }
            if (this.getResponse() != null) {
                assertion.assertResponse(new WsdlResponseMessageExchange(this), new WsdlTestRunContext(this.testStep));
                notifier.notifyChange();
            }
            return assertion;
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAssertion(TestAssertion assertion) {
        PropertyChangeNotifier notifier = new PropertyChangeNotifier();
        try {
            this.assertionsSupport.removeAssertion((WsdlMessageAssertion)assertion);
        }
        finally {
            ((WsdlMessageAssertion)assertion).release();
            notifier.notifyChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestAssertion moveAssertion(int ix, int offset) {
        WsdlMessageAssertion assertion = this.getAssertionAt(ix);
        PropertyChangeNotifier notifier = new PropertyChangeNotifier();
        try {
            WsdlMessageAssertion wsdlMessageAssertion = this.assertionsSupport.moveAssertion(ix, offset);
            return wsdlMessageAssertion;
        }
        finally {
            assertion.release();
            notifier.notifyChange();
        }
    }

    @Override
    public Assertable.AssertionStatus getAssertionStatus() {
        this.currentStatus = Assertable.AssertionStatus.UNKNOWN;
        if (this.messageExchange == null) {
            return this.currentStatus;
        }
        int cnt = this.getAssertionCount();
        if (cnt == 0) {
            return this.currentStatus;
        }
        boolean hasEnabled = false;
        for (int c = 0; c < cnt; ++c) {
            if (!this.getAssertionAt(c).isDisabled()) {
                hasEnabled = true;
            }
            if (this.getAssertionAt(c).getStatus() != Assertable.AssertionStatus.FAILED) continue;
            this.currentStatus = Assertable.AssertionStatus.FAILED;
            break;
        }
        if (this.currentStatus == Assertable.AssertionStatus.UNKNOWN && hasEnabled) {
            this.currentStatus = Assertable.AssertionStatus.VALID;
        }
        return this.currentStatus;
    }

    @Override
    public ImageIcon getIcon() {
        if (this.forLoadTest || this.getIconAnimator() == null) {
            return null;
        }
        TestMonitor testMonitor = SoapUI.getTestMonitor();
        if (testMonitor != null && testMonitor.hasRunningLoadTest(this.testStep.getTestCase())) {
            return disabledRequestIcon;
        }
        ImageIcon icon = this.getIconAnimator().getIcon();
        if (icon == this.getIconAnimator().getBaseIcon()) {
            Assertable.AssertionStatus status = this.getAssertionStatus();
            if (status == Assertable.AssertionStatus.VALID) {
                return validRequestIcon;
            }
            if (status == Assertable.AssertionStatus.FAILED) {
                return failedRequestIcon;
            }
            if (status == Assertable.AssertionStatus.UNKNOWN) {
                return unknownRequestIcon;
            }
        }
        return icon;
    }

    @Override
    public void addAssertionsListener(AssertionsListener listener) {
        this.assertionsSupport.addAssertionsListener(listener);
    }

    @Override
    public void removeAssertionsListener(AssertionsListener listener) {
        this.assertionsSupport.removeAssertionsListener(listener);
    }

    @Override
    public void updateConfig(WsdlRequestConfig request) {
        super.updateConfig(request);
        this.assertionsSupport.refresh();
        List<AttachmentConfig> attachmentConfigs = ((WsdlRequestConfig)this.getConfig()).getAttachmentList();
        for (int i = 0; i < attachmentConfigs.size(); ++i) {
            AttachmentConfig config = attachmentConfigs.get(i);
            this.getAttachmentsList().get(i).updateConfig(config);
        }
    }

    @Override
    public void release() {
        super.release();
        this.assertionsSupport.release();
    }

    @Override
    public String getAssertableContentAsXml() {
        return this.getAssertableContent();
    }

    @Override
    public String getAssertableContent() {
        return this.getResponse() == null ? null : this.getResponse().getContentAsString();
    }

    @Override
    public WsdlTestRequestStep getTestStep() {
        return this.testStep;
    }

    @Override
    public WsdlInterface getInterface() {
        return this.getOperation().getInterface();
    }

    @Override
    public TestAssertionRegistry.AssertableType getAssertableType() {
        return TestAssertionRegistry.AssertableType.BOTH;
    }

    public String getInterfaceName() {
        return this.testStep.getInterfaceName();
    }

    public String getOperationName() {
        return this.testStep.getOperationName();
    }

    @Override
    public TestAssertion cloneAssertion(TestAssertion source, String name) {
        return this.assertionsSupport.cloneAssertion(source, name);
    }

    @Override
    public WsdlMessageAssertion importAssertion(WsdlMessageAssertion source, boolean overwrite2, boolean createCopy, String newName) {
        return this.assertionsSupport.importAssertion(source, overwrite2, createCopy, newName);
    }

    @Override
    public List<TestAssertion> getAssertionList() {
        return new ArrayList<TestAssertion>(this.assertionsSupport.getAssertionList());
    }

    @Override
    public WsdlMessageAssertion getAssertionByName(String name) {
        return this.assertionsSupport.getAssertionByName(name);
    }

    @Override
    public ModelItem getModelItem() {
        return this.testStep;
    }

    @Override
    public Map<String, TestAssertion> getAssertions() {
        return this.assertionsSupport.getAssertions();
    }

    @Override
    public String getDefaultAssertableContent() {
        return this.getOperation().createResponse(true);
    }

    @Override
    public void resolve(ResolveContext<?> context) {
        super.resolve(context);
        this.assertionsSupport.resolve(context);
    }

    @Override
    public boolean isDiscardResponse() {
        return this.getSettings().getBoolean("discardResponse");
    }

    public void setDiscardResponse(boolean discardResponse) {
        this.getSettings().setBoolean("discardResponse", discardResponse);
    }

    protected static class TestRequestIconAnimator
    extends AbstractHttpRequest.RequestIconAnimator<WsdlTestRequest> {
        public TestRequestIconAnimator(WsdlTestRequest modelItem) {
            super(modelItem, "/request.gif", "/exec_request.gif", 4);
        }

        @Override
        public boolean beforeSubmit(Submit submit, SubmitContext context) {
            if (SoapUI.getTestMonitor() != null && SoapUI.getTestMonitor().hasRunningLoadTest(((WsdlTestRequest)this.getTarget()).getTestCase())) {
                return true;
            }
            return super.beforeSubmit(submit, context);
        }

        @Override
        public void afterSubmit(Submit submit, SubmitContext context) {
            if (submit.getRequest() == this.getTarget()) {
                this.stop();
            }
        }
    }

    private class PropertyChangeNotifier {
        private Assertable.AssertionStatus oldStatus;
        private ImageIcon oldIcon;

        public PropertyChangeNotifier() {
            this.oldStatus = WsdlTestRequest.this.getAssertionStatus();
            this.oldIcon = WsdlTestRequest.this.getIcon();
        }

        public void notifyChange() {
            Assertable.AssertionStatus newStatus = WsdlTestRequest.this.getAssertionStatus();
            ImageIcon newIcon = WsdlTestRequest.this.getIcon();
            if (this.oldStatus != newStatus) {
                WsdlTestRequest.this.notifyPropertyChanged(STATUS_PROPERTY, (Object)this.oldStatus, (Object)newStatus);
            }
            if (this.oldIcon != newIcon) {
                WsdlTestRequest.this.notifyPropertyChanged(ModelItem.ICON_PROPERTY, this.oldIcon, WsdlTestRequest.this.getIcon());
            }
            this.oldStatus = newStatus;
            this.oldIcon = newIcon;
        }
    }
}

