/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.HttpRequestConfig;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.support.http.HttpRequest;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertableConfig;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertionsSupport;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.HttpResponseMessageExchange;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestInterface;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.TestAssertionRegistry;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionsListener;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.monitor.TestMonitor;
import com.eviware.soapui.support.UISupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;

public class HttpTestRequest
extends HttpRequest
implements HttpTestRequestInterface<HttpRequestConfig> {
    private final boolean forLoadTest;
    private HttpTestRequestStep testStep;
    private AssertionsSupport assertionsSupport;
    private HttpResponseMessageExchange messageExchange;
    private PropertyChangeNotifier notifier;
    private Assertable.AssertionStatus currentStatus;
    private ImageIcon validRequestIcon;
    private ImageIcon failedRequestIcon;
    private ImageIcon disabledRequestIcon;
    private ImageIcon unknownRequestIcon;

    protected HttpTestRequest(HttpRequestConfig config, HttpTestRequestStep testStep, boolean forLoadTest) {
        super(config, forLoadTest);
        this.forLoadTest = forLoadTest;
        this.setSettings(new XmlBeansSettingsImpl(this, testStep.getSettings(), config.getSettings()));
        this.testStep = testStep;
        this.initAssertions();
        if (!forLoadTest) {
            this.initIcons();
        }
    }

    protected void initIcons() {
        this.validRequestIcon = UISupport.createImageIcon("/valid_http_request.gif");
        this.failedRequestIcon = UISupport.createImageIcon("/invalid_http_request.gif");
        this.unknownRequestIcon = UISupport.createImageIcon("/unknown_http_request.gif");
        this.disabledRequestIcon = UISupport.createImageIcon("/disabled_http_request.gif");
        this.setIconAnimator(new AbstractHttpRequest.RequestIconAnimator<HttpTestRequest>(this, "/http_request.gif", "/exec_http_request.gif", 4));
    }

    private void initAssertions() {
        this.assertionsSupport = new AssertionsSupport(this.testStep, new AssertableConfig(){

            @Override
            public TestAssertionConfig addNewAssertion() {
                return ((HttpRequestConfig)HttpTestRequest.this.getConfig()).addNewAssertion();
            }

            @Override
            public List<TestAssertionConfig> getAssertionList() {
                return ((HttpRequestConfig)HttpTestRequest.this.getConfig()).getAssertionList();
            }

            @Override
            public void removeAssertion(int ix) {
                ((HttpRequestConfig)HttpTestRequest.this.getConfig()).removeAssertion(ix);
            }

            @Override
            public TestAssertionConfig insertAssertion(TestAssertionConfig source, int ix) {
                TestAssertionConfig conf = ((HttpRequestConfig)HttpTestRequest.this.getConfig()).insertNewAssertion(ix);
                conf.set(source);
                return conf;
            }
        });
    }

    @Override
    public int getAssertionCount() {
        return this.assertionsSupport.getAssertionCount();
    }

    @Override
    public WsdlMessageAssertion getAssertionAt(int c) {
        return this.assertionsSupport.getAssertionAt(c);
    }

    @Override
    public void setResponse(HttpResponse response, SubmitContext context) {
        super.setResponse(response, context);
        this.assertResponse(context);
    }

    @Override
    public void assertResponse(SubmitContext context) {
        if (this.notifier == null) {
            this.notifier = new PropertyChangeNotifier();
        }
        HttpResponseMessageExchange httpResponseMessageExchange = this.messageExchange = this.getResponse() == null ? null : new HttpResponseMessageExchange(this);
        if (this.messageExchange != null) {
            for (WsdlMessageAssertion assertion : this.assertionsSupport.getAssertionList()) {
                assertion.assertResponse(this.messageExchange, context);
            }
        }
        this.notifier.notifyChange();
    }

    @Override
    public ImageIcon getIcon() {
        if (this.forLoadTest || this.getIconAnimator() == null) {
            return null;
        }
        TestMonitor testMonitor = SoapUI.getTestMonitor();
        if (testMonitor != null && (testMonitor.hasRunningLoadTest(this.getTestStep().getTestCase()) || testMonitor.hasRunningSecurityTest(this.getTestStep().getTestCase()))) {
            return this.disabledRequestIcon;
        }
        ImageIcon icon = this.getIconAnimator().getIcon();
        if (icon == this.getIconAnimator().getBaseIcon()) {
            Assertable.AssertionStatus status = this.getAssertionStatus();
            if (status == Assertable.AssertionStatus.VALID) {
                return this.validRequestIcon;
            }
            if (status == Assertable.AssertionStatus.FAILED) {
                return this.failedRequestIcon;
            }
            if (status == Assertable.AssertionStatus.UNKNOWN) {
                return this.unknownRequestIcon;
            }
        }
        return icon;
    }

    @Override
    public WsdlMessageAssertion addAssertion(String assertionLabel) {
        PropertyChangeNotifier notifier = new PropertyChangeNotifier();
        try {
            WsdlMessageAssertion assertion = this.assertionsSupport.addWsdlAssertion(assertionLabel);
            if (assertion == null) {
                return null;
            }
            if (this.getResponse() != null) {
                assertion.assertResponse(new HttpResponseMessageExchange(this), new WsdlTestRunContext(this.testStep));
                notifier.notifyChange();
            }
            return assertion;
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAssertion(TestAssertion assertion) {
        PropertyChangeNotifier notifier = new PropertyChangeNotifier();
        try {
            this.assertionsSupport.removeAssertion((WsdlMessageAssertion)assertion);
        }
        finally {
            ((WsdlMessageAssertion)assertion).release();
            notifier.notifyChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestAssertion moveAssertion(int ix, int offset) {
        PropertyChangeNotifier notifier = new PropertyChangeNotifier();
        WsdlMessageAssertion assertion = this.getAssertionAt(ix);
        try {
            WsdlMessageAssertion wsdlMessageAssertion = this.assertionsSupport.moveAssertion(ix, offset);
            return wsdlMessageAssertion;
        }
        finally {
            assertion.release();
            notifier.notifyChange();
        }
    }

    @Override
    public Assertable.AssertionStatus getAssertionStatus() {
        this.currentStatus = Assertable.AssertionStatus.UNKNOWN;
        if (this.messageExchange != null) {
            if (!this.messageExchange.hasResponse() && this.getOperation() != null && this.getOperation().isBidirectional()) {
                this.currentStatus = Assertable.AssertionStatus.FAILED;
            }
        } else {
            return this.currentStatus;
        }
        int cnt = this.getAssertionCount();
        if (cnt == 0) {
            return this.currentStatus;
        }
        for (int c = 0; c < cnt; ++c) {
            if (this.getAssertionAt(c).getStatus() != Assertable.AssertionStatus.FAILED) continue;
            this.currentStatus = Assertable.AssertionStatus.FAILED;
            break;
        }
        if (this.currentStatus == Assertable.AssertionStatus.UNKNOWN) {
            this.currentStatus = Assertable.AssertionStatus.VALID;
        }
        return this.currentStatus;
    }

    @Override
    public void addAssertionsListener(AssertionsListener listener) {
        this.assertionsSupport.addAssertionsListener(listener);
    }

    @Override
    public void removeAssertionsListener(AssertionsListener listener) {
        this.assertionsSupport.removeAssertionsListener(listener);
    }

    @Override
    public String getResponseContentAsString() {
        return this.getResponse() == null ? null : this.getResponse().getContentAsString();
    }

    @Override
    public String getAssertableContentAsXml() {
        return this.getResponseContentAsXml();
    }

    @Override
    public String getAssertableContent() {
        return this.getResponseContentAsString();
    }

    @Override
    public HttpTestRequestStep getTestStep() {
        return this.testStep;
    }

    @Override
    public TestAssertion cloneAssertion(TestAssertion source, String name) {
        return this.assertionsSupport.cloneAssertion(source, name);
    }

    @Override
    public List<TestAssertion> getAssertionList() {
        return new ArrayList<TestAssertion>(this.assertionsSupport.getAssertionList());
    }

    @Override
    public WsdlMessageAssertion getAssertionByName(String name) {
        return this.assertionsSupport.getAssertionByName(name);
    }

    @Override
    public Map<String, TestAssertion> getAssertions() {
        return this.assertionsSupport.getAssertions();
    }

    @Override
    public String getDefaultAssertableContent() {
        return "";
    }

    @Override
    public TestAssertionRegistry.AssertableType getAssertableType() {
        return TestAssertionRegistry.AssertableType.RESPONSE;
    }

    @Override
    public Interface getInterface() {
        return null;
    }

    @Override
    public void updateConfig(HttpRequestConfig request) {
        super.updateConfig(request);
        this.assertionsSupport.refresh();
    }

    @Override
    public WsdlTestCase getTestCase() {
        return this.testStep.getTestCase();
    }

    @Override
    public ModelItem getParent() {
        return this.getTestStep();
    }

    @Override
    public WsdlMessageAssertion importAssertion(WsdlMessageAssertion source, boolean overwrite2, boolean createCopy, String newName) {
        return this.assertionsSupport.importAssertion(source, overwrite2, createCopy, newName);
    }

    @Override
    public boolean isDiscardResponse() {
        return this.getSettings().getBoolean("discardResponse");
    }

    public void setDiscardResponse(boolean discardResponse) {
        this.getSettings().setBoolean("discardResponse", discardResponse);
    }

    private class PropertyChangeNotifier {
        private Assertable.AssertionStatus oldStatus;
        private ImageIcon oldIcon;

        public PropertyChangeNotifier() {
            this.oldStatus = HttpTestRequest.this.getAssertionStatus();
            this.oldIcon = HttpTestRequest.this.getIcon();
        }

        public void notifyChange() {
            Assertable.AssertionStatus newStatus = HttpTestRequest.this.getAssertionStatus();
            ImageIcon newIcon = HttpTestRequest.this.getIcon();
            if (this.oldStatus != newStatus) {
                HttpTestRequest.this.notifyPropertyChanged(HttpTestRequestInterface.STATUS_PROPERTY, (Object)this.oldStatus, (Object)newStatus);
            }
            if (this.oldIcon != newIcon) {
                HttpTestRequest.this.notifyPropertyChanged(ModelItem.ICON_PROPERTY, this.oldIcon, HttpTestRequest.this.getIcon());
            }
            this.oldStatus = newStatus;
            this.oldIcon = newIcon;
        }
    }
}

