/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.soap;

import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.support.soap.AbstractSoapBindingImporter;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlContext;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlUtils;
import com.eviware.soapui.settings.WsdlSettings;
import java.util.Collections;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.extensions.soap.SOAPBinding;
import org.apache.log4j.Logger;

public class Soap11HttpBindingImporter
extends AbstractSoapBindingImporter {
    private static final Logger log = Logger.getLogger(Soap11HttpBindingImporter.class);

    @Override
    public boolean canImport(Binding binding) {
        List list = binding.getExtensibilityElements();
        SOAPBinding soapBinding = WsdlUtils.getExtensiblityElement(list, SOAPBinding.class);
        return soapBinding == null ? false : soapBinding.getTransportURI().startsWith("http://schemas.xmlsoap.org/soap/http") || soapBinding.getTransportURI().startsWith("http://schemas.microsoft.com/wse/2003/06/tcp");
    }

    @Override
    public WsdlInterface importBinding(WsdlProject project, WsdlContext wsdlContext, Binding binding) throws Exception {
        String name = project.getSettings().getBoolean(WsdlSettings.NAME_WITH_BINDING) ? binding.getQName().getLocalPart() : binding.getPortType().getQName().getLocalPart();
        WsdlInterface iface = (WsdlInterface)project.addNewInterface(name, "wsdl");
        iface.setBindingName(binding.getQName());
        iface.setSoapVersion(SoapVersion.Soap11);
        String[] endpoints = WsdlUtils.getEndpointsForBinding(wsdlContext.getDefinition(), binding);
        for (int i = 0; i < endpoints.length; ++i) {
            log.info((Object)("importing endpoint " + endpoints[i]));
            iface.addEndpoint(endpoints[i]);
        }
        List list = binding.getBindingOperations();
        Collections.sort(list, new AbstractSoapBindingImporter.BindingOperationComparator());
        for (BindingOperation operation : list) {
            if (operation.getOperation() == null || operation.getOperation().isUndefined()) {
                log.error((Object)("BindingOperation [" + operation.getName() + "] is missing or referring to an invalid operation"));
                continue;
            }
            log.info((Object)("importing operation " + operation.getName()));
            iface.addNewOperation(operation);
        }
        this.initWsAddressing(binding, iface, wsdlContext.getDefinition());
        return iface;
    }
}

