/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.testsuite.TestRunContext;
import com.eviware.soapui.model.testsuite.TestRunnable;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.types.StringToObjectMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public abstract class AbstractTestRunner<T extends TestRunnable, T2 extends TestRunContext>
implements Runnable,
TestRunner {
    private final T testRunnable;
    private TestRunner.Status status;
    private Throwable error;
    private T2 runContext;
    private long startTime;
    private String reason;
    private volatile Future<?> future;
    private int id;
    private static final Logger log = Logger.getLogger(AbstractTestRunner.class);
    private static int idCounter = 0;
    private Timer timeoutTimer;
    private TimeoutTimerTask timeoutTimerTask;
    private Thread thread;
    private long timeTaken;

    public AbstractTestRunner(T modelItem, StringToObjectMap properties) {
        this.testRunnable = modelItem;
        this.status = TestRunner.Status.INITIALIZED;
        this.id = ++idCounter;
        this.runContext = this.createContext(properties);
    }

    public abstract T2 createContext(StringToObjectMap var1);

    public T2 getRunContext() {
        return this.runContext;
    }

    @Override
    public void start(boolean async) {
        this.status = TestRunner.Status.RUNNING;
        if (async) {
            this.future = SoapUI.getThreadPool().submit(this);
        } else {
            this.run();
        }
    }

    @Override
    public void cancel(String reason) {
        if (this.status == TestRunner.Status.CANCELED || this.status == TestRunner.Status.FINISHED || this.status == TestRunner.Status.FAILED || this.runContext == null) {
            return;
        }
        this.onCancel(reason);
        this.status = TestRunner.Status.CANCELED;
        this.reason = reason;
    }

    protected void onCancel(String reason2) {
    }

    @Override
    public void fail(String reason) {
        if (this.status == TestRunner.Status.CANCELED || this.status == TestRunner.Status.FAILED || this.runContext == null) {
            return;
        }
        this.onFail(reason);
        this.status = TestRunner.Status.FAILED;
        this.reason = reason;
    }

    protected void onFail(String reason) {
    }

    @Override
    public TestRunner.Status getStatus() {
        return this.status;
    }

    public int getId() {
        return this.id;
    }

    public Thread getThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.future != null) {
            this.thread = Thread.currentThread();
            if (System.getProperty("soapui.enablenamedthreads") != null) {
                this.thread.setName("TestRunner Thread for " + this.testRunnable.getName());
            }
        }
        try {
            this.status = TestRunner.Status.RUNNING;
            this.setStartTime();
            this.internalRun(this.runContext);
        }
        catch (Throwable t) {
            log.error((Object)"Exception during Test Execution", t);
            if (t instanceof OutOfMemoryError && UISupport.confirm("Exit now without saving?", "Out of Memory Error")) {
                System.exit(0);
            }
            this.status = TestRunner.Status.FAILED;
            this.error = t;
            this.reason = t.toString();
        }
        finally {
            this.setTimeTaken();
            if (this.timeoutTimer != null) {
                this.timeoutTimer.cancel();
            }
            if (this.status == TestRunner.Status.RUNNING) {
                this.status = TestRunner.Status.FINISHED;
            }
            this.internalFinally(this.runContext);
        }
    }

    protected void setStartTime() {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public boolean isRunning() {
        return this.getStatus() == TestRunner.Status.RUNNING;
    }

    public boolean isCanceled() {
        return this.getStatus() == TestRunner.Status.CANCELED;
    }

    public boolean isFailed() {
        return this.getStatus() == TestRunner.Status.FAILED;
    }

    protected void setStatus(TestRunner.Status status) {
        this.status = status;
    }

    protected void setError(Throwable error) {
        this.error = error;
    }

    protected abstract void internalRun(T2 var1) throws Exception;

    protected abstract void internalFinally(T2 var1);

    protected void startTimeoutTimer(long timeout) {
        this.timeoutTimer = new Timer();
        this.timeoutTimerTask = new TimeoutTimerTask();
        this.timeoutTimer.schedule((TimerTask)this.timeoutTimerTask, timeout);
    }

    public T getTestRunnable() {
        return this.testRunnable;
    }

    @Override
    public synchronized TestRunner.Status waitUntilFinished() {
        if (this.future != null) {
            if (!this.future.isDone()) {
                try {
                    this.future.get();
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                }
            }
        } else {
            throw new RuntimeException("cannot wait on null future");
        }
        return this.getStatus();
    }

    protected void setTimeTaken() {
        this.timeTaken = System.currentTimeMillis() - this.startTime;
    }

    @Override
    public long getTimeTaken() {
        return this.timeTaken;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    public Throwable getError() {
        return this.error;
    }

    @Override
    public String getReason() {
        return this.reason == null ? (this.error == null ? null : this.error.toString()) : this.reason;
    }

    private final class TimeoutTimerTask
    extends TimerTask {
        private TimeoutTimerTask() {
        }

        @Override
        public void run() {
            AbstractTestRunner.this.fail("TestCase timed out");
        }
    }
}

