/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.jms;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;

public class JMSEndpoint {
    public static final String JMS_OLD_ENDPOINT_SEPARATOR = "/";
    public static final String JMS_ENDPOINT_SEPARATOR = "::";
    public static final String QUEUE_ENDPOINT_PREFIX = "queue_";
    public static final String TOPIC_ENDPOINT_PREFIX = "topic_";
    public static final String JMS_EMPTY_DESTIONATION = "-";
    public static final String JMS_ENDPIONT_PREFIX = "jms://";
    Request request;
    SubmitContext submitContext;
    String[] parameters;
    String sessionName;
    String send;
    String receive;

    public JMSEndpoint(Request request, SubmitContext submitContext) {
        this.request = request;
        this.submitContext = submitContext;
        this.parameters = JMSEndpoint.extractEndpointParameters(request, submitContext);
        this.sessionName = this.getEndpointParameter(0);
        this.send = this.getEndpointParameter(1);
        this.receive = this.getEndpointParameter(2);
    }

    public JMSEndpoint(String sessionName, String send, String receive) {
        this.sessionName = sessionName;
        this.send = send;
        this.receive = receive;
    }

    public JMSEndpoint(String jmsEndpointString) {
        this.parameters = jmsEndpointString.replaceFirst(JMS_ENDPIONT_PREFIX, "").split(JMS_ENDPOINT_SEPARATOR);
        this.sessionName = this.getEndpointParameter(0);
        this.send = this.getEndpointParameter(1);
        this.receive = this.getEndpointParameter(2);
    }

    public static String[] extractEndpointParameters(Request request, SubmitContext context) {
        JMSEndpoint.resolveOldEndpointPattern(request);
        String endpoint = PropertyExpander.expandProperties(context, request.getEndpoint());
        String[] parameters = endpoint.replaceFirst(JMS_ENDPIONT_PREFIX, "").split(JMS_ENDPOINT_SEPARATOR);
        return parameters;
    }

    private static void resolveOldEndpointPattern(Request request) {
        String oldEndpoint = request.getEndpoint();
        if (oldEndpoint.contains("/queue_") || oldEndpoint.contains("/topic_")) {
            String newEndpoint = request.getEndpoint().replaceAll("/queue_", "::queue_").replaceAll("/topic_", "::topic_").replaceAll("/-", "::-");
            request.setEndpoint(newEndpoint);
            JMSEndpoint.refreshEndpointList(request, oldEndpoint, newEndpoint);
            SoapUI.log("JMS endpoint resolver changed endpoint pattern from " + oldEndpoint + "to " + newEndpoint);
        }
    }

    private static void refreshEndpointList(Request request, String oldEndpoint, String newEndpoint) {
        Interface iface = request.getOperation().getInterface();
        for (String endpoint : iface.getEndpoints()) {
            if (!endpoint.equals(oldEndpoint)) continue;
            iface.changeEndpoint(endpoint, newEndpoint);
        }
    }

    private String getEndpointParameter(int i) {
        if (i > this.parameters.length - 1) {
            return null;
        }
        String stripParameter = PropertyExpander.expandProperties(this.submitContext, this.parameters[i]).replaceFirst(QUEUE_ENDPOINT_PREFIX, "").replaceFirst(TOPIC_ENDPOINT_PREFIX, "");
        return stripParameter;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public String getSend() {
        return this.send;
    }

    public String getReceive() {
        return this.receive;
    }
}

