/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.transports.http.ExtendedHttpMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.SinglePartHttpResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlResponse;
import com.eviware.soapui.impl.wsdl.support.wss.IncomingWss;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import org.w3c.dom.Document;

public class WsdlSinglePartHttpResponse
extends SinglePartHttpResponse
implements WsdlResponse {
    private Vector<Object> wssResult;

    public WsdlSinglePartHttpResponse(WsdlRequest wsdlRequest, ExtendedHttpMethod postMethod, String requestContent, PropertyExpansionContext context) {
        super(wsdlRequest, postMethod, requestContent, context);
        this.processIncomingWss(wsdlRequest, context);
    }

    private void processIncomingWss(WsdlRequest wsdlRequest, PropertyExpansionContext context) {
        IncomingWss incomingWss = (IncomingWss)context.getProperty("WssRequestFilter#IncomingWss");
        if (incomingWss != null) {
            try {
                Document document = XmlUtils.parseXml(this.getResponseContent());
                this.wssResult = incomingWss.processIncoming(document, context);
                if (this.wssResult != null && this.wssResult.size() > 0) {
                    StringWriter writer = new StringWriter();
                    XmlUtils.serialize(document, (Writer)writer);
                    this.setResponseContent(writer.toString());
                }
            }
            catch (Exception e) {
                if (this.wssResult == null) {
                    this.wssResult = new Vector();
                }
                this.wssResult.add(e);
            }
        }
    }

    @Override
    public Vector<?> getWssResult() {
        return this.wssResult;
    }

    @Override
    public WsdlRequest getRequest() {
        return (WsdlRequest)super.getRequest();
    }
}

