/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.transports.http.BaseHttpResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.ExtendedHttpMethod;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.UnsupportedEncodingException;

public class SinglePartHttpResponse
extends BaseHttpResponse {
    private String responseContent;
    private String requestContent;
    private boolean prettyPrint;
    private long responseSize;

    public SinglePartHttpResponse(AbstractHttpRequestInterface<?> httpRequest, ExtendedHttpMethod httpMethod, String requestContent, PropertyExpansionContext context) {
        super(httpMethod, httpRequest, context);
        if (this.getRequestContent() == null || !this.getRequestContent().equals(requestContent)) {
            this.requestContent = requestContent;
        }
        try {
            byte[] responseBody = httpMethod.getResponseBody();
            int contentOffset = 0;
            if (responseBody == null) {
                responseBody = new byte[]{};
            }
            this.responseSize = responseBody.length;
            String contentType = httpMethod.getResponseContentType();
            String charset = httpMethod.getResponseCharSet();
            if (contentType != null && contentType.toLowerCase().endsWith("xml") && this.responseSize > 3L && responseBody[0] == -17 && responseBody[1] == -69 && responseBody[2] == -65) {
                charset = "UTF-8";
                contentOffset = 3;
            }
            if (charset == null) {
                charset = httpRequest.getEncoding();
            }
            charset = StringUtils.unquote(charset);
            try {
                this.responseContent = responseBody.length == 0 ? null : (charset == null ? new String(responseBody, contentOffset, (int)(this.responseSize - (long)contentOffset)) : new String(responseBody, contentOffset, (int)(this.responseSize - (long)contentOffset), charset));
            }
            catch (UnsupportedEncodingException e) {
                SoapUI.getErrorLog().warn((Object)e.toString());
                this.responseContent = new String(responseBody, contentOffset, (int)(this.responseSize - (long)contentOffset));
            }
            this.prettyPrint = httpRequest.getSettings().getBoolean(WsdlSettings.PRETTY_PRINT_RESPONSE_MESSAGES);
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    @Override
    public String getContentAsString() {
        if (this.prettyPrint) {
            this.responseContent = XmlUtils.prettyPrintXml(this.responseContent);
            this.prettyPrint = false;
        }
        return this.responseContent;
    }

    protected String getResponseContent() {
        return this.responseContent;
    }

    @Override
    public long getContentLength() {
        return this.responseSize;
    }

    @Override
    public String getRequestContent() {
        return this.requestContent == null ? super.getRequestContent() : this.requestContent;
    }

    @Override
    public void setResponseContent(String responseContent) {
        String oldContent = this.responseContent;
        this.responseContent = responseContent;
        ((AbstractHttpRequest)this.getRequest()).notifyPropertyChanged(WsdlRequest.RESPONSE_CONTENT_PROPERTY, oldContent, responseContent);
    }
}

