/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.wsdl.submit.filters.AbstractRequestFilter;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.types.StringToStringsMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GlobalHttpHeadersRequestFilter
extends AbstractRequestFilter {
    public static final String REPLACE_HEADERS_SYSTEM_PROPERTY = "soapui.http.global.headers.cache";
    public static final String CACHE_HEADERS_SYSTEM_PROPERTY = "soapui.http.global.headers.replace";
    public static final String HEADER_SYSTEM_PROPERTY_PREFIX = "soapui.http.global.header.";
    private static StringToStringsMap globalHeadersToAdd = new StringToStringsMap();
    private StringToStringsMap headersToAdd;
    private Map<AbstractHttpRequest, StringToStringsMap> savedHeaders = new HashMap<AbstractHttpRequest, StringToStringsMap>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void filterAbstractHttpRequest(SubmitContext context, AbstractHttpRequest<?> request) {
        if (this.headersToAdd == null || !this.isCacheHeaders()) {
            GlobalHttpHeadersRequestFilter globalHttpHeadersRequestFilter = this;
            synchronized (globalHttpHeadersRequestFilter) {
                if (this.headersToAdd == null || !this.isCacheHeaders()) {
                    this.initHeadersToAdd();
                }
            }
        }
        if (!this.headersToAdd.isEmpty()) {
            this.addHeadersToRequest(context, request);
        }
    }

    private boolean isCacheHeaders() {
        return Boolean.valueOf(System.getProperty(CACHE_HEADERS_SYSTEM_PROPERTY, "true"));
    }

    private void addHeadersToRequest(SubmitContext context, AbstractHttpRequest<?> request) {
        StringToStringsMap headers = request.getRequestHeaders();
        this.savedHeaders.put(request, this.createCopyOfHeaders(headers));
        boolean replaceHeaders = this.isReplaceHeaders();
        for (String name : this.headersToAdd.keySet()) {
            if (replaceHeaders && headers.containsKey(name)) {
                ((List)headers.get(name)).clear();
            }
            for (String value : (List)this.headersToAdd.get(name)) {
                headers.add(name, PropertyExpander.expandProperties(context, value));
            }
        }
        request.setRequestHeaders(headers);
    }

    private boolean isReplaceHeaders() {
        return Boolean.valueOf(System.getProperty(REPLACE_HEADERS_SYSTEM_PROPERTY, "false"));
    }

    private StringToStringsMap createCopyOfHeaders(StringToStringsMap headers) {
        StringToStringsMap result = new StringToStringsMap();
        for (String name : headers.keySet()) {
            result.put(name, new ArrayList((Collection)headers.get(name)));
        }
        return result;
    }

    private void initHeadersToAdd() {
        this.headersToAdd = new StringToStringsMap(globalHeadersToAdd);
        for (Object key : System.getProperties().keySet()) {
            String headerValue;
            String headerName;
            if (!String.valueOf(key).startsWith(HEADER_SYSTEM_PROPERTY_PREFIX) || (headerName = String.valueOf(key).substring(HEADER_SYSTEM_PROPERTY_PREFIX.length())).length() <= 0 || !StringUtils.hasContent(headerValue = System.getProperty(String.valueOf(key)))) continue;
            this.headersToAdd.add(headerName, headerValue);
        }
    }

    @Override
    public void afterAbstractHttpResponse(SubmitContext context, AbstractHttpRequestInterface<?> request) {
        if (this.savedHeaders.containsKey(request)) {
            request.setRequestHeaders(this.savedHeaders.get(request));
            this.savedHeaders.remove(request);
        }
    }

    public static void addGlobalHeader(String name, String value) {
        globalHeadersToAdd.add(name, value);
    }

    public static void removeGlobalHeader(String name, String value) {
        if (value == null) {
            globalHeadersToAdd.remove(name);
        } else if (globalHeadersToAdd.containsKey(name)) {
            ((List)globalHeadersToAdd.get(name)).remove(value);
        }
    }
}

