/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps.amf;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.panels.teststeps.amf.SoapUIAMFConnection;
import com.eviware.soapui.model.iface.SubmitContext;
import flex.messaging.io.amf.client.exceptions.ClientStatusException;
import flex.messaging.io.amf.client.exceptions.ServerStatusException;
import flex.messaging.messages.CommandMessage;
import flex.messaging.util.Base64;

public class AMFCredentials {
    public static final String DESTINATION = "auth";
    private String endpoint;
    private String username;
    private String password;
    private SubmitContext context;
    private boolean logedIn;

    public AMFCredentials(String endpoint, String username, String password, SubmitContext context) {
        this.endpoint = endpoint;
        this.username = username;
        this.password = password;
        this.context = context;
    }

    public SoapUIAMFConnection login() throws ClientStatusException, ServerStatusException {
        CommandMessage commandMessage = this.createLoginCommandMessage();
        SoapUIAMFConnection amfConnection = new SoapUIAMFConnection();
        amfConnection.connect(this.endpoint);
        amfConnection.call(this.context, null, commandMessage);
        this.logedIn = true;
        return amfConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logout(SubmitContext context) {
        SoapUIAMFConnection connection = (SoapUIAMFConnection)context.getProperty("AMF_CONNECTION");
        CommandMessage commandMessage = AMFCredentials.createLogoutCommandMessage();
        try {
            connection.call(context, null, commandMessage);
        }
        catch (ClientStatusException e) {
            SoapUI.logError(e);
        }
        catch (ServerStatusException e) {
            SoapUI.logError(e);
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() {
        SoapUIAMFConnection connection = (SoapUIAMFConnection)this.context.getProperty("AMF_CONNECTION");
        CommandMessage commandMessage = AMFCredentials.createLogoutCommandMessage();
        try {
            connection.call(this.context, null, commandMessage);
        }
        catch (ClientStatusException e) {
            SoapUI.logError(e);
        }
        catch (ServerStatusException e) {
            SoapUI.logError(e);
        }
        finally {
            connection.close();
        }
    }

    private CommandMessage createLoginCommandMessage() {
        CommandMessage commandMessage = new CommandMessage();
        commandMessage.setOperation(8);
        String credString = this.username + ":" + this.password;
        Base64.Encoder encoder = new Base64.Encoder(credString.length());
        encoder.encode(credString.getBytes());
        commandMessage.setBody((Object)encoder.drain());
        commandMessage.setDestination(DESTINATION);
        return commandMessage;
    }

    private static CommandMessage createLogoutCommandMessage() {
        CommandMessage commandMessage = new CommandMessage();
        commandMessage.setOperation(9);
        commandMessage.setDestination(DESTINATION);
        return commandMessage;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public SubmitContext getContext() {
        return this.context;
    }

    public void setLogedIn(boolean logedIn) {
        this.logedIn = logedIn;
    }

    public boolean isLoggedIn() {
        return this.logedIn;
    }
}

