/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.SoapUIActions;
import com.eviware.soapui.impl.rest.RestMethod;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.panels.request.AbstractRestRequestDesktopPanel;
import com.eviware.soapui.impl.rest.support.RestUtils;
import com.eviware.soapui.impl.support.components.ModelItemXmlEditor;
import com.eviware.soapui.impl.wsdl.panels.teststeps.AssertionsPanel;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequestInterface;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.actions.AddAssertionAction;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionsListener;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.monitor.support.TestMonitorListenerAdapter;
import com.eviware.soapui.security.SecurityTestRunner;
import com.eviware.soapui.support.DateUtil;
import com.eviware.soapui.support.ListDataChangeListener;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.log.JLogList;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.util.Date;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;

public class RestTestRequestDesktopPanel
extends AbstractRestRequestDesktopPanel<RestTestRequestStep, RestTestRequest> {
    private JLogList logArea;
    private InternalTestMonitorListener testMonitorListener = new InternalTestMonitorListener();
    private JButton addAssertionButton;
    protected JComboBox methodResourceCombo;
    private AssertionsPanel assertionsPanel;
    private JInspectorPanel inspectorPanel;
    private JComponentInspector<?> assertionInspector;
    private JComponentInspector<?> logInspector;
    private InternalAssertionsListener assertionsListener = new InternalAssertionsListener();
    private long startTime;
    protected JLabel pathLabel;

    public RestTestRequestDesktopPanel(RestTestRequestStep requestStep) {
        super(requestStep, requestStep.getTestRequest());
        SoapUI.getTestMonitor().addTestMonitorListener(this.testMonitorListener);
        this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(requestStep.getTestCase()));
        requestStep.getTestRequest().addAssertionsListener(this.assertionsListener);
    }

    protected JComponent buildLogPanel() {
        this.logArea = new JLogList("Request Log");
        this.logArea.getLogList().getModel().addListDataListener(new ListDataChangeListener(){

            @Override
            public void dataChanged(ListModel model) {
                RestTestRequestDesktopPanel.this.logInspector.setTitle("Request Log (" + model.getSize() + ")");
            }
        });
        return this.logArea;
    }

    protected AssertionsPanel buildAssertionsPanel() {
        return new AssertionsPanel((Assertable)this.getRequest()){

            @Override
            protected void selectError(AssertionError error) {
                ModelItemXmlEditor<?, ?> editor = RestTestRequestDesktopPanel.this.getResponseEditor();
                editor.requestFocus();
            }
        };
    }

    @Override
    public void setContent(JComponent content) {
        this.inspectorPanel.setContentComponent(content);
    }

    @Override
    public void removeContent(JComponent content) {
        this.inspectorPanel.setContentComponent(null);
    }

    @Override
    protected String getHelpUrl() {
        return "http://www.soapui.org/Functional-Testing/testrequest-editor.html";
    }

    @Override
    protected JComponent buildContent() {
        JComponent component = super.buildContent();
        this.inspectorPanel = JInspectorPanelFactory.build(component);
        this.assertionsPanel = this.buildAssertionsPanel();
        this.assertionInspector = new JComponentInspector<AssertionsPanel>(this.assertionsPanel, "Assertions (" + ((RestTestRequestStep)this.getModelItem()).getAssertionCount() + ")", "Assertions for this Test Request", true);
        this.inspectorPanel.addInspector(this.assertionInspector);
        this.logInspector = new JComponentInspector<JComponent>(this.buildLogPanel(), "Request Log (0)", "Log of requests", true);
        this.inspectorPanel.addInspector(this.logInspector);
        this.inspectorPanel.setDefaultDividerLocation(0.6f);
        this.inspectorPanel.setCurrentInspector("Assertions");
        this.updateStatusIcon();
        return this.inspectorPanel.getComponent();
    }

    private void updateStatusIcon() {
        Assertable.AssertionStatus status = ((RestTestRequestStep)this.getModelItem()).getTestRequest().getAssertionStatus();
        switch (status) {
            case FAILED: {
                this.assertionInspector.setIcon(UISupport.createImageIcon("/failed_assertion.gif"));
                this.inspectorPanel.activate(this.assertionInspector);
                break;
            }
            case UNKNOWN: {
                this.assertionInspector.setIcon(UISupport.createImageIcon("/unknown_assertion.gif"));
                break;
            }
            case VALID: {
                this.assertionInspector.setIcon(UISupport.createImageIcon("/valid_assertion.gif"));
                this.inspectorPanel.deactivate();
            }
        }
    }

    @Override
    protected void addTopToolbarComponents(JXToolBar toolBar) {
    }

    @Override
    protected void addBottomToolbar(JPanel panel) {
        if (((RestTestRequest)this.getRequest()).getResource() != null) {
            JXToolBar toolbar = UISupport.createToolbar();
            this.methodResourceCombo = new JComboBox(new PathComboBoxModel());
            this.methodResourceCombo.setRenderer(new RestMethodListCellRenderer());
            this.methodResourceCombo.setPreferredSize(new Dimension(200, 20));
            this.methodResourceCombo.setSelectedItem(((RestTestRequest)this.getRequest()).getRestMethod());
            toolbar.addLabeledFixed("Resource/Method:", this.methodResourceCombo);
            toolbar.addSeparator();
            this.pathLabel = new JLabel();
            this.updateFullPathLabel();
            toolbar.add(this.pathLabel);
            panel.add((Component)toolbar, "South");
        }
    }

    @Override
    protected void updateUiValues() {
        this.updateFullPathLabel();
    }

    private void updateFullPathLabel() {
        if (this.pathLabel != null && ((RestTestRequest)this.getRequest()).getResource() != null) {
            String text = RestUtils.expandPath(((RestTestRequest)this.getRequest()).getResource().getFullPath(), ((RestTestRequest)this.getRequest()).getParams(), (RestRequestInterface)this.getRequest());
            this.pathLabel.setText("[" + text + "]");
            this.pathLabel.setToolTipText(text);
        }
    }

    @Override
    protected void insertButtons(JXToolBar toolbar) {
        this.addAssertionButton = RestTestRequestDesktopPanel.createActionButton(new AddAssertionAction((Assertable)this.getRequest()), true);
        toolbar.add(this.addAssertionButton);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled) {
            enabled = !SoapUI.getTestMonitor().hasRunningLoadTest(((RestTestRequestStep)this.getModelItem()).getTestCase()) && !SoapUI.getTestMonitor().hasRunningSecurityTest(((RestTestRequestStep)this.getModelItem()).getTestCase());
        }
        super.setEnabled(enabled);
        this.addAssertionButton.setEnabled(enabled);
        this.assertionsPanel.setEnabled(enabled);
        if (SoapUI.getTestMonitor().hasRunningLoadTest(((RestTestRequest)this.getRequest()).getTestCase()) || SoapUI.getTestMonitor().hasRunningSecurityTest(((RestTestRequest)this.getRequest()).getTestCase())) {
            ((RestTestRequest)this.getRequest()).removeSubmitListener(this);
        } else {
            ((RestTestRequest)this.getRequest()).addSubmitListener(this);
        }
    }

    @Override
    protected Submit doSubmit() throws Request.SubmitException {
        Analytics.trackAction((String)SoapUIActions.RUN_TEST_STEP.getActionName(), (String[])new String[]{"StepType", "REST"});
        return ((RestTestRequest)this.getRequest()).submit(new WsdlTestRunContext((TestStep)this.getModelItem()), true);
    }

    @Override
    public boolean beforeSubmit(Submit submit, SubmitContext context) {
        boolean result = super.beforeSubmit(submit, context);
        this.startTime = System.currentTimeMillis();
        return result;
    }

    @Override
    protected void logMessages(String message, String infoMessage) {
        super.logMessages(message, infoMessage);
        this.logArea.addLine(DateUtil.formatFull(new Date(this.startTime)) + " - " + message);
    }

    @Override
    public void afterSubmit(Submit submit, SubmitContext context) {
        super.afterSubmit(submit, context);
        if (!this.isHasClosed()) {
            this.updateStatusIcon();
        }
    }

    @Override
    public boolean onClose(boolean canCancel) {
        if (super.onClose(canCancel)) {
            this.assertionsPanel.release();
            this.inspectorPanel.release();
            SoapUI.getTestMonitor().removeTestMonitorListener(this.testMonitorListener);
            ((RestTestRequestStep)this.getModelItem()).getTestRequest().removeAssertionsListener(this.assertionsListener);
            return true;
        }
        return false;
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        if (((RestTestRequest)this.getRequest()).getResource() == null) {
            return modelItem == this.getRequest() || modelItem == this.getModelItem() || modelItem == ((RestTestRequest)this.getRequest()).getOperation() || modelItem == ((RestTestRequestStep)this.getModelItem()).getTestCase() || modelItem == ((RestTestRequestStep)this.getModelItem()).getTestCase().getTestSuite() || modelItem == ((RestTestRequestStep)this.getModelItem()).getTestCase().getTestSuite().getProject();
        }
        return modelItem == this.getRequest() || modelItem == this.getModelItem() || modelItem == ((RestTestRequest)this.getRequest()).getOperation() || modelItem == ((RestTestRequest)this.getRequest()).getOperation().getInterface() || modelItem == ((RestTestRequest)this.getRequest()).getOperation().getInterface().getProject() || modelItem == ((RestTestRequestStep)this.getModelItem()).getTestCase() || modelItem == ((RestTestRequestStep)this.getModelItem()).getTestCase().getTestSuite();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals(RestTestRequestInterface.STATUS_PROPERTY)) {
            this.updateStatusIcon();
        }
    }

    private class RestMethodListCellRenderer
    extends DefaultListCellRenderer {
        private RestMethodListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof RestMethod) {
                RestMethod item = (RestMethod)value;
                this.setIcon(item.getIcon());
                this.setText(item.getResource().getName() + " -> " + item.getName());
            }
            return result;
        }
    }

    private class PathComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private PathComboBoxModel() {
        }

        @Override
        public int getSize() {
            int sz = 0;
            for (RestResource resource : ((RestTestRequest)RestTestRequestDesktopPanel.this.getRequest()).getResource().getService().getAllResources()) {
                sz += resource.getRestMethodCount();
            }
            return sz;
        }

        @Override
        public Object getElementAt(int index) {
            int sz = 0;
            for (RestResource resource : ((RestTestRequest)RestTestRequestDesktopPanel.this.getRequest()).getResource().getService().getAllResources()) {
                if (index < sz + resource.getRestMethodCount()) {
                    return resource.getRestMethodAt(index - sz);
                }
                sz += resource.getRestMethodCount();
            }
            return null;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            ((RestTestRequest)RestTestRequestDesktopPanel.this.getRequest()).getTestStep().setRestMethod((RestMethod)anItem);
        }

        @Override
        public Object getSelectedItem() {
            return ((RestTestRequest)RestTestRequestDesktopPanel.this.getRequest()).getRestMethod();
        }
    }

    private class InternalTestMonitorListener
    extends TestMonitorListenerAdapter {
        private InternalTestMonitorListener() {
        }

        @Override
        public void loadTestFinished(LoadTestRunner runner) {
            RestTestRequestDesktopPanel.this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(((RestTestRequestStep)RestTestRequestDesktopPanel.this.getModelItem()).getTestCase()));
        }

        @Override
        public void loadTestStarted(LoadTestRunner runner) {
            if (runner.getLoadTest().getTestCase() == ((RestTestRequestStep)RestTestRequestDesktopPanel.this.getModelItem()).getTestCase()) {
                RestTestRequestDesktopPanel.this.setEnabled(false);
            }
        }

        @Override
        public void securityTestFinished(SecurityTestRunner runner) {
            RestTestRequestDesktopPanel.this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(((RestTestRequestStep)RestTestRequestDesktopPanel.this.getModelItem()).getTestCase()));
        }

        @Override
        public void securityTestStarted(SecurityTestRunner runner) {
            if (runner.getSecurityTest().getTestCase() == ((RestTestRequestStep)RestTestRequestDesktopPanel.this.getModelItem()).getTestCase()) {
                RestTestRequestDesktopPanel.this.setEnabled(false);
            }
        }

        @Override
        public void testCaseFinished(TestCaseRunner runner) {
            RestTestRequestDesktopPanel.this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(((RestTestRequestStep)RestTestRequestDesktopPanel.this.getModelItem()).getTestCase()));
        }

        @Override
        public void testCaseStarted(TestCaseRunner runner) {
            if (runner.getTestCase() == ((RestTestRequestStep)RestTestRequestDesktopPanel.this.getModelItem()).getTestCase()) {
                RestTestRequestDesktopPanel.this.setEnabled(false);
            }
        }
    }

    private final class InternalAssertionsListener
    implements AssertionsListener {
        private InternalAssertionsListener() {
        }

        @Override
        public void assertionAdded(TestAssertion assertion) {
            RestTestRequestDesktopPanel.this.assertionInspector.setTitle("Assertions (" + ((RestTestRequestStep)RestTestRequestDesktopPanel.this.getModelItem()).getAssertionCount() + ")");
        }

        @Override
        public void assertionRemoved(TestAssertion assertion) {
            RestTestRequestDesktopPanel.this.assertionInspector.setTitle("Assertions (" + ((RestTestRequestStep)RestTestRequestDesktopPanel.this.getModelItem()).getAssertionCount() + ")");
        }

        @Override
        public void assertionMoved(TestAssertion assertion, int ix, int offset) {
            RestTestRequestDesktopPanel.this.assertionInspector.setTitle("Assertions (" + ((RestTestRequestStep)RestTestRequestDesktopPanel.this.getModelItem()).getAssertionCount() + ")");
        }
    }
}

